/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.analysis.utils.StringStats;
import com.metaeffekt.artifact.terms.model.TermsMetaData;

public class MatchItem {
    private final StringStats matchStringStats;
    private final MatchType matchType;
    private final TermsMetaData sourceLicenseMetaData;
    private final CharSequence matchContext;

    public String deriveColor(TermsMetaData contextLicenseMetaData) {
        int r = 200;
        int g = 200;
        int b = 200;
        String a = "0.5";
        switch (this.matchType) {
            case GRANT_MATCH: {
                r = 0;
                g = 200;
                b = 0;
                break;
            }
            case OBLIGATION_MATCH: {
                r = 200;
                g = 200;
                b = 0;
                break;
            }
            case EVIDENCE_MATCH: {
                r = 0;
                g = 200;
                b = 200;
                break;
            }
            case EVIDENCE_EXCLUDE: {
                r = 200;
                g = 0;
                b = 0;
            }
        }
        if (contextLicenseMetaData == this.sourceLicenseMetaData) {
            a = "0.7";
        }
        return "rgba(" + r + ", " + g + ", " + b + ", " + a + ")";
    }

    public MatchItem(StringStats matchStringStats, MatchType matchType, CharSequence matchContext, TermsMetaData sourceLicenseMetaData) {
        this.matchStringStats = matchStringStats;
        this.matchType = matchType;
        this.matchContext = matchContext;
        this.sourceLicenseMetaData = sourceLicenseMetaData;
    }

    public StringStats getMatchStringStats() {
        return this.matchStringStats;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public CharSequence getMatchContext() {
        return this.matchContext;
    }

    public TermsMetaData getSourceLicenseMetaData() {
        return this.sourceLicenseMetaData;
    }

    public static enum MatchType {
        EVIDENCE_MATCH,
        EVIDENCE_ONE_OF_MATCH,
        EVIDENCE_EXCLUDE,
        GRANT_MATCH,
        OBLIGATION_MATCH,
        NAME_MATCH,
        REFERENCE_MATCH,
        IGNORED_NAME_MATCH,
        NOT_MATCHED;

    }
}

