/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResolverUtils.class);

    public static File findLicenseFor(TermsMetaData tmd, NormalizationMetaData normMeta) {
        HashSet<String> visited = new HashSet<String>();
        TermsMetaData currentTmd = tmd;
        while (!visited.contains(currentTmd.getCanonicalName())) {
            String namedEquivalence;
            visited.add(currentTmd.getCanonicalName());
            if (currentTmd.getLicenseFile() != null) {
                File licenseFileToRead = new File(currentTmd.getLicenseFile());
                if (Files.isRegularFile(licenseFileToRead.toPath(), new LinkOption[0]) && licenseFileToRead.exists()) {
                    return licenseFileToRead;
                }
                LOG.error("Tmd [{}] had bad license file [{}] while looking for text for [{}]: Not a file.", new Object[]{currentTmd.getCanonicalName(), licenseFileToRead, tmd.getCanonicalName()});
            }
            if ((namedEquivalence = tmd.getNamedEquivalence()) == null) break;
            currentTmd = normMeta.findTermsMetaData(namedEquivalence);
            if (currentTmd != null) continue;
            LOG.error("No Tmd found for named equivalence [{}], named in license [{}].", (Object)namedEquivalence, (Object)tmd.getCanonicalName());
            break;
        }
        return null;
    }
}

