/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.base;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.PTag;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class DescriptionParagraph {
    private final String header;
    private final String content;

    public DescriptionParagraph(String header, String content) {
        this.header = StringUtils.isEmpty(header) ? null : header;
        this.content = StringUtils.isEmpty(content) ? null : content;
    }

    public String getHeader() {
        return this.header;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isEmpty() {
        return this.header == null && this.content == null;
    }

    public String toString() {
        return this.toMarkdownString(1);
    }

    public String toMarkdownString(int header) {
        StringBuilder headerBuilder = new StringBuilder();
        boolean headerExists = StringUtils.hasText(this.header);
        boolean contentExists = StringUtils.hasText(this.content);
        if (headerExists) {
            for (int i = 0; i < header; ++i) {
                headerBuilder.append("#");
            }
        }
        headerBuilder.append(headerExists ? " " : "").append(headerExists ? this.header : "").append(headerExists && contentExists ? "\n" : "").append(contentExists ? this.content : "");
        return headerBuilder.toString();
    }

    public PTag toHtmlH1Tag() {
        return (PTag)((PTag)TagCreator.p().with((DomContent)TagCreator.h1((String)this.header))).with((DomContent)TagCreator.text((String)this.content));
    }

    public JSONObject toJson() {
        return new JSONObject().put("header", (Object)this.header).put("content", (Object)this.content);
    }

    public static DescriptionParagraph fromTitleAndContent(String title, String content) {
        return new DescriptionParagraph(title, content);
    }

    public static DescriptionParagraph fromTitle(String title) {
        return new DescriptionParagraph(title, null);
    }

    public static DescriptionParagraph fromContent(String content) {
        return new DescriptionParagraph(null, content);
    }

    public static DescriptionParagraph fromJson(JSONObject json) {
        return new DescriptionParagraph(json.optString("header", null), json.optString("content", null));
    }

    public static List<DescriptionParagraph> fromJson(JSONArray json) {
        ArrayList<DescriptionParagraph> paragraphs = new ArrayList<DescriptionParagraph>();
        if (json == null) {
            return paragraphs;
        }
        for (int i = 0; i < json.length(); ++i) {
            paragraphs.add(DescriptionParagraph.fromJson(json.optJSONObject(i)));
        }
        return paragraphs;
    }

    public DescriptionParagraph deriveWithHeader(String header) {
        return new DescriptionParagraph(header, this.content);
    }
}

