/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.cpe;

import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.contents.base.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.json.JSONObject;
import us.springett.parsers.cpe.Cpe;

public class NvdCpeMetadata {
    private static final String NVD_BASE_URL = "https://nvd.nist.gov/products/cpe/detail/";
    private final Cpe cpe;
    private final boolean deprecated;
    private final String nvdId;
    private final Map<String, String> titles;
    private final List<Reference> references;

    public NvdCpeMetadata(Cpe cpe, boolean deprecated, String nvdId, Map<String, String> titles, List<Reference> references) {
        this.cpe = cpe;
        this.deprecated = deprecated;
        this.nvdId = nvdId;
        this.titles = titles;
        this.references = references;
    }

    public NvdCpeMetadata(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document must not be null.");
        }
        this.cpe = document.getField("cpe23Uri") != null ? (Cpe)CommonEnumerationUtil.parseCpe(document.getField("cpe23Uri").stringValue()).orElse(null) : null;
        this.deprecated = document.getField("deprecated") != null && document.getField("deprecated").stringValue().equals("true");
        this.nvdId = document.getField("nvdId") != null ? document.getField("nvdId").stringValue() : null;
        this.titles = document.getField("titles") != null ? this.parseTitles(document.getField("titles").stringValue()) : new HashMap<String, String>();
        this.references = document.getField("references") != null ? Reference.fromJsonArray(new JSONArray(document.getField("references").stringValue())) : new ArrayList<Reference>();
    }

    private Map<String, String> parseTitles(String titles) {
        if (titles.startsWith("[")) {
            JSONArray titlesArray = new JSONArray(titles);
            return IntStream.range(0, titlesArray.length()).mapToObj(arg_0 -> ((JSONArray)titlesArray).getJSONObject(arg_0)).collect(Collectors.toMap(title -> title.getString("lang"), title -> title.getString("title"), (a, b) -> a));
        }
        return new HashMap<String, String>();
    }

    public Cpe getCpe() {
        return this.cpe;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getNvdId() {
        return this.nvdId;
    }

    public Map<String, String> getTitles() {
        return this.titles;
    }

    public String getEnglishTitleOrFallbackAny() {
        if (this.titles.containsKey("en")) {
            return this.titles.get("en");
        }
        if (!this.titles.isEmpty()) {
            return this.titles.values().iterator().next();
        }
        return null;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public String toUrl() {
        return NVD_BASE_URL + this.nvdId;
    }

    public JSONObject toJson() {
        return new JSONObject().put("cpe", this.cpe != null ? CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(this.cpe) : null).put("deprecated", this.deprecated).put("nvdId", (Object)this.nvdId).put("titles", this.titles).put("references", (Collection)this.references.stream().map(Reference::toJson).collect(Collectors.toList()));
    }

    public String toString() {
        return "NvdCpeMetadata{cpe=" + this.cpe + ", deprecated=" + this.deprecated + ", nvdId='" + this.nvdId + '\'' + ", titles=" + this.titles + ", references=" + this.references + '}';
    }
}

