/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.eol.export;

import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.export.CycleScenarioRating;
import org.json.JSONObject;

public enum CycleStateExtendedSupportInformationNotPresent {
    SUPPORT_VALID("supportValid", CycleScenarioRating.RATING_1),
    SUPPORT_ENDING_SOON("supportEndingSoon", CycleScenarioRating.RATING_4),
    SUPPORT_EXPIRED("supportExpired", CycleScenarioRating.RATING_5);

    private final String key;
    private final CycleScenarioRating rating;

    private CycleStateExtendedSupportInformationNotPresent(String key, CycleScenarioRating rating) {
        this.key = key;
        this.rating = rating;
    }

    public String getKey() {
        return this.key;
    }

    public CycleScenarioRating getRating() {
        return this.rating;
    }

    public JSONObject toJson() {
        return new JSONObject().put("key", (Object)this.key).put("rating", this.getRating().getRating());
    }

    public static CycleStateExtendedSupportInformationNotPresent from(EolCycle cycle, long millisUntilEol) {
        long timeUntilSupportEnd = cycle.getTimeUntilSupportEnd();
        if (timeUntilSupportEnd <= 0L) {
            return SUPPORT_EXPIRED;
        }
        if (timeUntilSupportEnd < millisUntilEol) {
            return SUPPORT_ENDING_SOON;
        }
        return SUPPORT_VALID;
    }

    public static CycleStateExtendedSupportInformationNotPresent fromJson(JSONObject jsonObject) {
        String key = jsonObject.getString("key");
        for (CycleStateExtendedSupportInformationNotPresent value : CycleStateExtendedSupportInformationNotPresent.values()) {
            if (!value.getKey().equals(key)) continue;
            return value;
        }
        throw new IllegalArgumentException("No enum constant for key: " + key);
    }
}

