/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.msrcdata;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsrcProduct {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcProduct.class);
    private final String id;
    private final String name;
    private final String vendor;
    private final String family;

    public MsrcProduct(String id, String name, String vendor, String family) {
        if (StringUtils.isEmpty(id)) {
            LOG.warn("Product ID is empty on MS product");
        }
        this.id = id;
        this.name = name;
        this.vendor = vendor;
        this.family = family;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getFamily() {
        return this.family;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.name);
        json.put("vendor", (Object)this.vendor);
        json.put("family", (Object)this.family);
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public Document toDocument() {
        Document doc = new Document();
        if (this.id != null) {
            doc.add((IndexableField)new TextField("id", this.id, Field.Store.YES));
        }
        if (this.name != null) {
            doc.add((IndexableField)new TextField("name", this.name, Field.Store.YES));
        }
        if (this.vendor != null) {
            doc.add((IndexableField)new TextField("vendor", this.vendor, Field.Store.YES));
        }
        if (this.family != null) {
            doc.add((IndexableField)new TextField("family", this.family, Field.Store.YES));
        }
        return doc;
    }

    public static MsrcProduct fromJson(JSONObject json) {
        return new MsrcProduct(json.optString("id", null), json.optString("name", null), json.optString("vendor", null), json.optString("family", null));
    }

    public static MsrcProduct fromDocument(Document doc) {
        return new MsrcProduct(doc.get("id"), doc.get("name"), doc.get("vendor"), doc.get("family"));
    }
}

