/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.msrcdata;

import com.metaeffekt.mirror.contents.msrcdata.MsrcSupersedeNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class MsrcSupersedeNodeRelations {
    private final Set<String> affectsVulnerabilities = new HashSet<String>();
    private final Set<MsrcSupersedeNode> supersededBy = new HashSet<MsrcSupersedeNode>();
    private final Set<MsrcSupersedeNode> supersedes = new HashSet<MsrcSupersedeNode>();

    public void addAffectsVulnerability(String vid) {
        this.affectsVulnerabilities.add(vid);
    }

    public void addAffectsVulnerability(Collection<String> vids) {
        this.affectsVulnerabilities.addAll(vids);
    }

    public void addSupersededBy(MsrcSupersedeNode node) {
        this.supersededBy.add(node);
    }

    public void addSupersededBy(Collection<MsrcSupersedeNode> supersededBy) {
        this.supersededBy.addAll(supersededBy);
    }

    public void addSupersedes(MsrcSupersedeNode node) {
        this.supersedes.add(node);
    }

    public void addSupersedes(Collection<MsrcSupersedeNode> supersedes) {
        this.supersedes.addAll(supersedes);
    }

    public Set<String> getAffectsVulnerabilities() {
        return this.affectsVulnerabilities;
    }

    public Set<MsrcSupersedeNode> getSupersededBy() {
        return this.supersededBy;
    }

    public Set<MsrcSupersedeNode> getSupersedes() {
        return this.supersedes;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("vuln", (Object)new JSONArray(this.affectsVulnerabilities));
        json.put("supBy", (Object)new JSONArray((Collection)this.supersededBy.stream().map(MsrcSupersedeNode::getKbId).collect(Collectors.toList())));
        json.put("sup", (Object)new JSONArray((Collection)this.supersedes.stream().map(MsrcSupersedeNode::getKbId).collect(Collectors.toList())));
        return json;
    }

    public static MsrcSupersedeNodeRelations fromJson(JSONObject json, Map<String, MsrcSupersedeNode> nodes) {
        MsrcSupersedeNodeRelations node = new MsrcSupersedeNodeRelations();
        node.addAffectsVulnerability(json.getJSONArray("vuln").toList().stream().map(Object::toString).collect(Collectors.toList()));
        node.addSupersededBy(json.getJSONArray("supBy").toList().stream().map(Object::toString).map(s -> nodes.computeIfAbsent((String)s, MsrcSupersedeNode::new)).collect(Collectors.toList()));
        node.addSupersedes(json.getJSONArray("sup").toList().stream().map(Object::toString).map(s -> nodes.computeIfAbsent((String)s, MsrcSupersedeNode::new)).collect(Collectors.toList()));
        return node;
    }

    public String toString() {
        return this.toJson().toString();
    }
}

