/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.store;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.query.NvdCveIndexQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityTypeStore
extends ContentIdentifierStore<VulnerabilityTypeIdentifier<?>> {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilityTypeStore.class);
    public static final VulnerabilityTypeIdentifier<Vulnerability> CVE = new VulnerabilityTypeIdentifier<Vulnerability>("CVE", "CVE", "", Pattern.compile("((?:CVE|CAN)-([0-9]{4})-([0-9]{4,}))", 2), Vulnerability.class, Vulnerability::new, NvdCveIndexQuery.class, NvdCveIndexQuery::new);
    public static final VulnerabilityTypeIdentifier<? extends Vulnerability> ANY_VULNERABILITY_FILTER_WILDCARD = new VulnerabilityTypeIdentifier<Vulnerability>("any", "any", "any", Pattern.compile("(any|all)", 2), Vulnerability.class, Vulnerability::new, null, null);
    private static final VulnerabilityTypeStore INSTANCE = new VulnerabilityTypeStore();

    public static VulnerabilityTypeStore get() {
        return INSTANCE;
    }

    protected VulnerabilityTypeStore() {
    }

    @Override
    protected VulnerabilityTypeIdentifier<?> createIdentifier(@NonNull String name, @NonNull String implementation) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation is marked non-null but is null");
        }
        if (name.equalsIgnoreCase("any") || implementation.equalsIgnoreCase("all")) {
            return ANY_VULNERABILITY_FILTER_WILDCARD;
        }
        return new VulnerabilityTypeIdentifier<Vulnerability>(name, ContentIdentifierStore.ContentIdentifier.deriveWellFormedName(name), implementation, Pattern.compile("UNKNOWN", 2), Vulnerability.class, Vulnerability::new, null, null);
    }

    @Override
    protected Collection<VulnerabilityTypeIdentifier<?>> createDefaultIdentifiers() {
        return Arrays.asList(CVE);
    }

    @Override
    public ContentIdentifierStore.SingleContentIdentifierParseResult<VulnerabilityTypeIdentifier<?>> fromJsonNameAndImplementation(JSONObject json) {
        ContentIdentifierStore.SingleContentIdentifierParseResult<VulnerabilityTypeIdentifier<?>> superResult = super.fromJsonNameAndImplementation(json);
        if (superResult.getIdentifier() instanceof VulnerabilityTypeIdentifier) {
            return superResult;
        }
        throw new IllegalArgumentException("The provided JSON object does not represent a vulnerability type identifier, which is an impossible scenario since this class can by definition only support advisory type identifiers.");
    }

    @Override
    public ContentIdentifierStore.SingleContentIdentifierParseResult<VulnerabilityTypeIdentifier<?>> fromMap(Map<String, Object> map) {
        ContentIdentifierStore.SingleContentIdentifierParseResult<VulnerabilityTypeIdentifier<?>> superResult = super.fromMap(map);
        if (superResult.getIdentifier() instanceof VulnerabilityTypeIdentifier) {
            return superResult;
        }
        throw new IllegalArgumentException("The provided map does not represent a vulnerability type identifier, which is an impossible scenario since this class can by definition only support advisory type identifiers.");
    }

    public ContentIdentifierStore.SingleContentIdentifierParseResult<VulnerabilityTypeIdentifier<?>> fromAdvisoryMetaData(AdvisoryMetaData amd) {
        String source = (String)ObjectUtils.firstNonNull((Object[])new String[]{amd.get(AdvisoryMetaData.Attribute.SOURCE)});
        String implementation = (String)ObjectUtils.firstNonNull((Object[])new String[]{amd.get(AdvisoryMetaData.Attribute.SOURCE_IMPLEMENTATION)});
        String entryId = (String)ObjectUtils.firstNonNull((Object[])new String[]{amd.get(AdvisoryMetaData.Attribute.NAME)});
        if (StringUtils.isEmpty(source)) {
            if (StringUtils.isEmpty(entryId)) {
                throw new IllegalArgumentException("The vulnerability meta data does not contain a source or name attribute, which is required to determine the advisory type.");
            }
            for (VulnerabilityTypeIdentifier typeIdentifier : this.values()) {
                if (!typeIdentifier.patternMatchesId(entryId)) continue;
                return new ContentIdentifierStore.SingleContentIdentifierParseResult(typeIdentifier, entryId);
            }
            throw new IllegalArgumentException("The vulnerability meta data does not contain a source attribute, which is required to determine the advisory type.");
        }
        VulnerabilityTypeIdentifier advisoryTypeIdentifier = (VulnerabilityTypeIdentifier)this.fromNameAndImplementation(source, implementation);
        return new ContentIdentifierStore.SingleContentIdentifierParseResult(advisoryTypeIdentifier, entryId);
    }

    public void inferSourceIdentifierFromIdIfAbsent(Vulnerability vulnerability) {
        if (vulnerability.getSourceIdentifier() == null) {
            this.fromId(vulnerability.getId()).ifPresent(inferred -> {
                if (log.isDebugEnabled()) {
                    log.debug("Inferred source identifier [{}] for vulnerability [{}]", (Object)inferred.toExtendedString(), (Object)vulnerability.getId());
                }
                vulnerability.setSourceIdentifier((VulnerabilityTypeIdentifier<?>)inferred);
            });
        }
    }

    public String toString() {
        return "VulnerabilityTypeStore()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VulnerabilityTypeStore)) {
            return false;
        }
        VulnerabilityTypeStore other = (VulnerabilityTypeStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof VulnerabilityTypeStore;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

