/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download;

import com.metaeffekt.artifact.analysis.utils.BuildProperties;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.GitAccess;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.concurrency.ScheduledDelayedThreadPoolExecutor;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.WebAccess;
import com.metaeffekt.mirror.download.advisor.CertFrDownload;
import com.metaeffekt.mirror.download.advisor.CertSeiDownload;
import com.metaeffekt.mirror.download.advisor.MsrcDownload;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.download.nvd.CpeDictionaryDownload;
import com.metaeffekt.mirror.download.nvd.NvdCpeApiDownload;
import com.metaeffekt.mirror.download.nvd.NvdCveApiDownload;
import com.metaeffekt.mirror.download.nvd.NvdDownload;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Download
extends Mirror {
    private static final Logger LOG = LoggerFactory.getLogger(Download.class);
    protected final Map<ResourceLocation, String> resourceLocations = new LinkedHashMap<ResourceLocation, String>();
    protected final WebAccess downloader = new WebAccess();
    protected final GitAccess git = new GitAccess();
    protected final File downloadIntoDirectory;
    protected long maxAgeBeforeRecheck = 86400000L;
    protected long maxAgeBeforeReset = 2419200000L;
    protected int lockFileTimeout = 600000;
    protected final ScheduledDelayedThreadPoolExecutor executor = new ScheduledDelayedThreadPoolExecutor(16, 0L);

    public Download(File baseMirrorDirectory, Class<? extends Download> downloadClass) {
        super(baseMirrorDirectory, Download.getDirectoryIdentifier(downloadClass));
        this.downloadIntoDirectory = new File(new File(this.baseMirrorDirectory, "download"), this.mirrorIdentifier);
    }

    public void setMaxAgeBeforeRecheck(long maxAgeBeforeRecheck) {
        this.maxAgeBeforeRecheck = maxAgeBeforeRecheck;
    }

    public void setMaxAgeBeforeReset(long maxAgeBeforeReset) {
        this.maxAgeBeforeReset = maxAgeBeforeReset;
    }

    public void setLockFileTimeout(int lockFileTimeout) {
        this.lockFileTimeout = lockFileTimeout;
    }

    public void setDownloaderProxyCredentials(String scheme, String host, int port, String username, String password) {
        this.downloader.setDownloaderProxyCredentials(scheme, host, port, username, password);
        this.git.setProxyConfig(scheme, host, port, username, password);
    }

    public File getDownloadIntoDirectory() {
        return this.downloadIntoDirectory;
    }

    public void setRemoteResourceLocation(ResourceLocation location, String url) {
        this.resourceLocations.put(location, url);
    }

    public abstract void setRemoteResourceLocation(String var1, String var2);

    public String getRemoteResourceLocation(ResourceLocation location) {
        return this.resourceLocations.getOrDefault(location, location.getDefault());
    }

    public URL getRemoteResourceLocationUrl(ResourceLocation location, Object ... args) {
        String requestUrlString = String.format(this.getRemoteResourceLocation(location), args);
        try {
            return new URL(requestUrlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Request URL is malformed in download: " + requestUrlString, e);
        }
    }

    public void performInternalDownload() {
        throw new UnsupportedOperationException("Internal download is not supported for " + this.getClass().getSimpleName() + " download");
    }

    public void performDownloadIfRequired() {
        boolean outcome = false;
        try {
            super.logTitle("");
            super.waitForFileUnlockIfLocked(this.downloadIntoDirectory, this.lockFileTimeout);
            super.lockFile(this.downloadIntoDirectory);
            if (this.isResetRequired()) {
                this.clearDownload();
                this.setLastResetToNow();
            }
            if (this.isDownloadRequired()) {
                this.performDownload();
                this.setLastUpdatedToNow();
            } else {
                LOG.info("Download is already up to date: {}", (Object)this.downloadIntoDirectory);
            }
            this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.DOWNLOAD_FAILED_FLAG.getKey(), "false");
            outcome = true;
        }
        catch (Exception e) {
            try {
                this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.DOWNLOAD_FAILED_FLAG.getKey(), "true");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Unable to update download " + this.getClass().getSimpleName() + " in " + this.downloadIntoDirectory + "\n" + e.getMessage(), e);
        }
        finally {
            super.unlockFile(this.downloadIntoDirectory);
            if (outcome) {
                super.logTitle("Done: ");
            } else {
                super.logTitle("FAILED: ");
            }
        }
    }

    protected boolean isDownloadRequired() {
        this.setLastCheckedToNow();
        boolean downloadFailed = this.hasLastDownloadFailed();
        if (downloadFailed) {
            LOG.info("Download failed previously, update is required");
            return true;
        }
        long directoryLastModified = this.getDownloadDirectoryLastModified();
        if (this.isUpdatedAgeOlderThan(directoryLastModified, this.maxAgeBeforeRecheck)) {
            LOG.info("Last update is further back than [{}], update is required", (Object)TimeUtils.formatTimeDiff(this.maxAgeBeforeRecheck));
            return true;
        }
        if (this.additionalIsDownloadRequired()) {
            LOG.info("Datasets have changed, update is required");
            return true;
        }
        return false;
    }

    public boolean hasLastDownloadFailed() {
        return this.propertyFiles.getBoolean(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.DOWNLOAD_FAILED_FLAG.getKey()).orElse(false);
    }

    protected long getDownloadDirectoryLastModified() {
        return this.propertyFiles.getLong(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_UPDATED.getKey()).orElse(0L);
    }

    protected boolean isResetRequired() {
        long directoryLastReset = this.propertyFiles.getLong(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_RESET.getKey()).orElse(0L);
        if (directoryLastReset == 0L) {
            this.setLastResetToNow();
            return false;
        }
        return this.isUpdatedAgeOlderThan(directoryLastReset, this.maxAgeBeforeReset);
    }

    private void setLastUpdatedToNow() {
        long now = TimeUtils.utcNow();
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_UPDATED.getKey(), now);
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_UPDATED_FORMATTED.getKey(), new Date(now));
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.MIRROR_VERSION.getKey(), BuildProperties.getProjectVersion());
        LOG.info("Set last updated to [{}] in {}", (Object)new Date(now), (Object)this.downloadIntoDirectory);
    }

    private void setLastCheckedToNow() {
        long now = TimeUtils.utcNow();
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_CHECKED.getKey(), now);
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_CHECKED_FORMATTED.getKey(), new Date(now));
        LOG.info("Set last updated to [{}] in {}", (Object)new Date(now), (Object)this.downloadIntoDirectory);
    }

    private void setLastResetToNow() {
        long now = TimeUtils.utcNow();
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_RESET.getKey(), now);
    }

    public void clearDownload() {
        LOG.info("Clearing download in {}", (Object)this.downloadIntoDirectory.getAbsolutePath());
        this.propertyFiles.flushCachedAePropertyFiles();
        FileUtils.deleteDir(this.downloadIntoDirectory);
        this.additionalClearDownload();
        LOG.info("Cleared download in {}", (Object)this.downloadIntoDirectory.getAbsolutePath());
    }

    protected void additionalClearDownload() {
    }

    protected abstract void performDownload();

    protected abstract boolean additionalIsDownloadRequired();

    public static String getDirectoryIdentifier(Class<? extends Download> download) {
        if (download.isAnnotationPresent(MirrorMetadata.class)) {
            return download.getAnnotation(MirrorMetadata.class).directoryName();
        }
        LOG.warn("Index {} does not have a directory name annotation", (Object)download.getSimpleName());
        if (NvdCveApiDownload.class.equals(download)) {
            return "nvd";
        }
        if (NvdDownload.class.equals(download)) {
            return "nvd-legacy-feed";
        }
        if (MsrcDownload.class.equals(download)) {
            return "msrc";
        }
        if (CpeDictionaryDownload.class.equals(download)) {
            return "cpe-dict-legacy-feed";
        }
        if (NvdCpeApiDownload.class.equals(download)) {
            return "cpe-dict";
        }
        if (CertSeiDownload.class.equals(download)) {
            return "certsei";
        }
        if (CertFrDownload.class.equals(download)) {
            return "certfr";
        }
        throw new RuntimeException("Unknown download class: " + download);
    }

    public static Download getInstance(Class<? extends Download> clazz, File baseMirrorDirectory) {
        try {
            return clazz.getConstructor(File.class).newInstance(baseMirrorDirectory);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create download class: " + e);
        }
    }
}

