/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download;

import com.metaeffekt.mirror.Retry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAccess {
    private static final Logger LOG = LoggerFactory.getLogger(WebAccess.class);
    private HttpHost proxy;
    private CredentialsProvider credentialsProvider;

    public void setDownloaderProxyCredentials(String scheme, String host, int port, String username, String password) {
        LOG.debug("Setting up proxy credentials for downloader.");
        this.proxy = new HttpHost(host, port, scheme);
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClient = HttpClients.custom();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        httpClient.setDefaultRequestConfig(requestConfig);
        if (this.credentialsProvider != null) {
            httpClient.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        return httpClient.build();
    }

    private RequestConfig createProxyRequestConfig() {
        if (this.proxy != null) {
            return RequestConfig.custom().setProxy(this.proxy).build();
        }
        return RequestConfig.custom().build();
    }

    public InputStream fetchResponseBodyFromUrlAsInputStream(URL url, Map<String, String> requestHeaders) {
        LOG.info("Performing request to {}", (Object)url);
        return new Retry<InputStream>(() -> {
            try (CloseableHttpClient httpClient = this.createHttpClient();){
                HttpGet httpGet = new HttpGet(url.toURI());
                httpGet.setConfig(this.createProxyRequestConfig());
                if (requestHeaders != null && !requestHeaders.isEmpty()) {
                    for (Map.Entry header : requestHeaders.entrySet()) {
                        httpGet.addHeader((String)header.getKey(), (String)header.getValue());
                    }
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                HttpEntity entity = response.getEntity();
                InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)entity.getContent());
                return inputStream;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to fetch response body from URL " + url.toString(), e);
            }
        }).retryCount(3).withDelay(1000).run();
    }

    public List<String> fetchResponseBodyFromUrlAsList(URL url, Map<String, String> requestHeaders) {
        LineIterator lineIterator;
        InputStream inputStream = this.fetchResponseBodyFromUrlAsInputStream(url, requestHeaders);
        try {
            lineIterator = IOUtils.lineIterator((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read response body from URL " + url.toString(), e);
        }
        ArrayList<String> lines = new ArrayList<String>();
        while (lineIterator.hasNext()) {
            lines.add(lineIterator.next());
        }
        return lines;
    }

    public List<String> fetchResponseBodyFromUrlAsList(URL url) {
        return this.fetchResponseBodyFromUrlAsList(url, null);
    }

    public Document fetchResponseBodyFromUrlAsDocument(URL url) {
        return Jsoup.parse((String)String.join((CharSequence)"", this.fetchResponseBodyFromUrlAsList(url)));
    }

    public void fetchResponseBodyFromUrlToFile(URL url, File file, Map<String, String> requestHeaders) {
        InputStream inputStream = this.fetchResponseBodyFromUrlAsInputStream(url, requestHeaders);
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write response from " + url.toString() + " to " + file.getAbsolutePath(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public void fetchResponseBodyFromUrlToFile(URL url, File file) {
        this.fetchResponseBodyFromUrlToFile(url, file, null);
    }

    public long fetchFileSizeFromUrl(URL url) {
        return this.fetchFileSizeFromUrl(url, true);
    }

    public long fetchFileSizeFromUrl(URL url, boolean downloadFallback) {
        return new Retry<Number>(() -> {
            try (CloseableHttpClient httpClient = this.createHttpClient();){
                int bytesRead;
                HttpGet httpGet = new HttpGet(url.toURI());
                httpGet.setConfig(this.createProxyRequestConfig());
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                HttpEntity entity = response.getEntity();
                if (entity.getContentLength() != -1L) {
                    Long l = entity.getContentLength();
                    return l;
                }
                if (!downloadFallback) {
                    Integer n = -1;
                    return n;
                }
                LOG.debug("Response did not contain Content-Length header, falling back to fetching the whole file for URL {}", (Object)url);
                long size = 0L;
                byte[] buffer = new byte[1024];
                while ((bytesRead = entity.getContent().read(buffer)) != -1) {
                    size += (long)bytesRead;
                }
                Long l = size;
                return l;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to fetch file size from URL " + url.toString(), e);
            }
        }).retryCount(3).withDelay(1000).run().longValue();
    }

    public String buildGetRequest(String baseUrl, Map<String, String> arguments) throws UnsupportedEncodingException {
        StringBuilder url = new StringBuilder();
        url.append(baseUrl);
        if (arguments != null) {
            boolean first = true;
            for (Map.Entry<String, String> entry : arguments.entrySet()) {
                if (first) {
                    url.append("?");
                    first = false;
                } else {
                    url.append("&");
                }
                url.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                url.append("=");
                url.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        return url.toString();
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }
}

