/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.nvd;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.mirror.Retry;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="cpe-dict", mavenPropertyName="nvdCpeDownload")
public class NvdCpeApiDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCpeApiDownload.class);
    private static final SimpleDateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final int API_DELAY_BETWEEN_AUTHORIZED_REQUESTS = 620;
    private static final int API_DELAY_BETWEEN_UNAUTHORIZED_REQUESTS = 6400;
    private String apiKey;
    private final List<JSONArray> apiResponseDataToBeProcessed = Collections.synchronizedList(new ArrayList());

    public NvdCpeApiDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdCpeApiDownload.class);
    }

    public NvdCpeApiDownload setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    protected void performDownload() {
        boolean fullMirrorRequired = this.isFullMirrorRequired();
        if (fullMirrorRequired) {
            LOG.info("Downloading initial NVD data from NVD API");
        } else {
            LOG.info("Existing mirror detected. Downloading incremental NVD data from NVD API");
        }
        long baseSleepDuration = this.apiKey == null ? 6400L : 620L;
        this.executor.setSize(4);
        this.executor.setDelay(baseSleepDuration);
        LOG.info("Requests {} be authorized with an API key, delay between requests [{}]", (Object)(this.apiKey == null ? "will not" : "will"), (Object)TimeUtils.formatTimeDiff(baseSleepDuration));
        long lastModified = this.getDownloadDirectoryLastModified();
        Date lastModifiedDate = new Date(lastModified);
        Date now = new Date(TimeUtils.utcNow());
        this.downloadCpeDictionaryApiData(fullMirrorRequired, lastModifiedDate, now);
        this.downloadCpeMatchApiData(fullMirrorRequired, lastModifiedDate, now);
    }

    private void downloadCpeDictionaryApiData(boolean fullMirrorRequired, Date lastModifiedDate, Date now) {
        LOG.info("Downloading NVD CPE Dictionary API data...");
        this.downloadCpeApiDataFromSource(fullMirrorRequired, lastModifiedDate, now, ResourceLocationNvd.CPE_API_LIST_ALL, ResourceLocationNvd.CPE_API_START_END_DATE);
        LOG.info("Finished processing NVD CPE Dictionary API data");
    }

    private void downloadCpeMatchApiData(boolean fullMirrorRequired, Date lastModifiedDate, Date now) {
        LOG.info("Downloading NVD CPE Match API data...");
        this.downloadCpeApiDataFromSource(fullMirrorRequired, lastModifiedDate, now, ResourceLocationNvd.CPE_MATCH_API_LIST_ALL, ResourceLocationNvd.CPE_MATCH_API_START_END_DATE);
        LOG.info("Finished processing NVD CPE Match API data");
    }

    private void downloadCpeApiDataFromSource(boolean fullMirrorRequired, Date lastModifiedDate, Date now, ResourceLocationNvd cpeApiListAll, ResourceLocationNvd cpeApiStartEndDate) {
        this.createDownloadThreads(fullMirrorRequired, lastModifiedDate, now, cpeApiListAll, cpeApiStartEndDate);
        for (int i = 0; i < 5; ++i) {
            this.processResponseDataUntilDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponseDataUntilDone() {
        ArrayList<Object> copy;
        List<JSONArray> list;
        this.executor.start();
        do {
            list = this.apiResponseDataToBeProcessed;
            synchronized (list) {
                if (this.apiResponseDataToBeProcessed.size() >= 4) {
                    copy = new ArrayList<JSONArray>(this.apiResponseDataToBeProcessed);
                    this.apiResponseDataToBeProcessed.clear();
                } else {
                    copy = new ArrayList();
                }
            }
            if (!copy.isEmpty()) {
                this.processApiCpeItems(copy);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.executor.isRunning());
        list = this.apiResponseDataToBeProcessed;
        synchronized (list) {
            if (!this.apiResponseDataToBeProcessed.isEmpty()) {
                copy = new ArrayList<JSONArray>(this.apiResponseDataToBeProcessed);
                this.apiResponseDataToBeProcessed.clear();
            } else {
                copy = new ArrayList();
            }
        }
        if (!copy.isEmpty()) {
            this.processApiCpeItems(copy);
        }
    }

    private void createDownloadThreads(boolean fullMirrorRequired, Date lastModifiedDate, Date now, ResourceLocationNvd locationAll, ResourceLocationNvd locationStartEndDate) {
        this.executor.submit(() -> {
            JSONObject json = this.downloadCpeDecideWhatTimeFrame(fullMirrorRequired, lastModifiedDate, now, 0, locationAll, locationStartEndDate);
            int totalResults = json.getInt("totalResults");
            int resultsPerPage = json.getInt("resultsPerPage");
            int currentStartIndex = 0;
            if (totalResults == 0) {
                LOG.info("No CPEs found for the given range.");
                return;
            }
            LOG.info("Downloaded CPEs [{}] to [{}] of [{}]", new Object[]{currentStartIndex, currentStartIndex + resultsPerPage, totalResults});
            this.appendJsonToProcessResponseCache(json);
            while (currentStartIndex < totalResults) {
                int finalCurrentStartIndex = currentStartIndex += resultsPerPage;
                this.executor.submit(() -> {
                    JSONObject subJson = this.downloadCpeDecideWhatTimeFrame(fullMirrorRequired, lastModifiedDate, now, finalCurrentStartIndex, locationAll, locationStartEndDate);
                    int subTotalResults = subJson.getInt("totalResults");
                    int subResultsPerPage = subJson.getInt("resultsPerPage");
                    LOG.info("Downloaded CPEs [{}] to [{}] of [{}]", new Object[]{finalCurrentStartIndex, finalCurrentStartIndex + subResultsPerPage, subTotalResults});
                    this.appendJsonToProcessResponseCache(subJson);
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendJsonToProcessResponseCache(JSONObject json) {
        JSONArray arr = (JSONArray)ObjectUtils.firstNonNull((Object[])new JSONArray[]{json.optJSONArray("products"), json.optJSONArray("matchStrings")});
        if (arr == null) {
            LOG.error("Unable to find 'products' or 'matchStrings' in the JSON response: {}", (Object)json.keySet());
        } else {
            List<JSONArray> list = this.apiResponseDataToBeProcessed;
            synchronized (list) {
                this.apiResponseDataToBeProcessed.add(arr);
            }
        }
    }

    private JSONObject downloadCpeDecideWhatTimeFrame(boolean fullMirrorRequired, Date lastModifiedDate, Date now, int offset, ResourceLocationNvd locationAll, ResourceLocationNvd locationStartEndDate) {
        AtomicReference json = new AtomicReference();
        new Retry(() -> {
            if (fullMirrorRequired) {
                json.set(this.downloadCpePage(offset, locationAll));
            } else {
                json.set(this.downloadCpePage(offset, lastModifiedDate, now, locationStartEndDate));
            }
        }).withDelay(9600).onException(Exception.class).retryCount(8).run();
        return (JSONObject)json.get();
    }

    private void processApiCpeItems(Collection<JSONArray> cpesArrays) {
        int sizeAfter;
        ArrayList<JSONArray> convertedProducts = new ArrayList<JSONArray>();
        for (JSONArray jSONArray : cpesArrays) {
            JSONArray convertedProductArray = new JSONArray();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject product = jSONArray.getJSONObject(i);
                JSONObject unwrapped = NvdCpeApiDownload.unwrapCpeEntry(product);
                JSONObject converted = this.convertCpeMatchToCpeDictItem(unwrapped);
                convertedProductArray.put((Object)converted);
            }
            convertedProducts.add(convertedProductArray);
        }
        HashMap<Integer, JSONArray> yearCves = new HashMap<Integer, JSONArray>();
        for (JSONArray cpesArray : convertedProducts) {
            Map<Integer, JSONArray> byYear = this.sortCpesIntoYears(cpesArray);
            for (Map.Entry<Integer, JSONArray> yearEntry : byYear.entrySet()) {
                JSONArray appendArray = yearCves.computeIfAbsent(yearEntry.getKey(), k -> new JSONArray());
                for (int i = 0; i < yearEntry.getValue().length(); ++i) {
                    appendArray.put((Object)yearEntry.getValue().getJSONObject(i));
                }
            }
        }
        int n = cpesArrays.stream().mapToInt(JSONArray::length).sum();
        if (n != (sizeAfter = yearCves.values().stream().mapToInt(JSONArray::length).sum())) {
            LOG.error("Dropped at least one CPE whilst sorting CPEs into yearly files: [{}] -> [{}]", (Object)n, (Object)sizeAfter);
        }
        this.processApiCpeItems(yearCves);
    }

    private void processApiCpeItems(Map<Integer, JSONArray> yearCves) {
        if (yearCves.size() == 0) {
            LOG.warn("No CPEs to process from the API.");
            return;
        }
        LOG.info("Processing CPE data from years: [{}]", (Object)yearCves.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(JSONArray::length).reversed())).map(e -> e.getKey() + " = " + ((JSONArray)e.getValue()).length()).collect(Collectors.joining("; ")));
        for (Map.Entry<Integer, JSONArray> entry : yearCves.entrySet()) {
            int year = entry.getKey();
            JSONArray cpes = entry.getValue();
            JSONArray existingJson = this.parseCpeItemsFromDownloadedYear(year);
            JSONArray mergedJson = this.mergeCpeItems(Arrays.asList(cpes, existingJson));
            LOG.info("Year: [{}], merging existing with downloaded [{} + {} --> {}]", new Object[]{year, existingJson.length(), cpes.length(), mergedJson.length()});
            File cveFile = new File(this.downloadIntoDirectory, year + ".json");
            try {
                FileUtils.write((File)cveFile, (CharSequence)mergedJson.toString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e2) {
                throw new RuntimeException("Unable to write NVD CPE year file " + cveFile.getAbsolutePath(), e2);
            }
        }
    }

    private JSONObject convertCpeMatchToCpeDictItem(JSONObject cpe) {
        if (!(cpe.has("criteria") && cpe.has("matchCriteriaId") && cpe.has("lastModified") && cpe.has("created"))) {
            return cpe;
        }
        return new JSONObject().put("deprecated", false).put("cpeName", (Object)cpe.getString("criteria")).put("cpeNameId", (Object)cpe.getString("matchCriteriaId")).put("lastModified", (Object)cpe.getString("lastModified")).put("created", (Object)cpe.getString("created"));
    }

    private static JSONObject unwrapCpeEntry(JSONObject cpeMatch) {
        if (cpeMatch.has("cpe")) {
            return cpeMatch.getJSONObject("cpe");
        }
        if (cpeMatch.has("matchString")) {
            return cpeMatch.getJSONObject("matchString");
        }
        return cpeMatch;
    }

    private JSONArray parseCpeItemsFromDownloadedYear(int year) {
        File cveFile = new File(this.downloadIntoDirectory, year + ".json");
        if (!cveFile.exists()) {
            return new JSONArray();
        }
        try {
            String content = FileUtils.readFileToString((File)cveFile, (Charset)StandardCharsets.UTF_8);
            return new JSONArray(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read NVD CPE year file " + cveFile.getAbsolutePath(), e);
        }
    }

    private Map<Integer, JSONArray> sortCpesIntoYears(JSONArray cpesArray) {
        int countAfter;
        HashMap<Integer, JSONArray> yearCves = new HashMap<Integer, JSONArray>();
        if (cpesArray == null) {
            LOG.warn("No CPEs to process from the API while sorting CPEs into years.");
            return yearCves;
        }
        for (int i = 0; i < cpesArray.length(); ++i) {
            JSONObject cpe = cpesArray.getJSONObject(i);
            if (!cpe.has("created")) {
                throw new RuntimeException("CPE entry does not provide 'created' timestamp: " + cpe);
            }
            String createdTimestamp = cpe.getString("created");
            int year = Integer.parseInt(createdTimestamp.substring(0, 4));
            if (year < 1999 || year > 9999) {
                LOG.warn("CPE entry most likely has invalid year [{}]", (Object)cpe);
            }
            yearCves.computeIfAbsent(year, k -> new JSONArray()).put((Object)cpe);
        }
        int countBefore = cpesArray.length();
        if (countBefore != (countAfter = yearCves.values().stream().mapToInt(JSONArray::length).sum())) {
            LOG.warn("CPEs were lost during sorting into years: [{} --> {}]", (Object)countBefore, (Object)countAfter);
        }
        return yearCves;
    }

    private JSONArray mergeCpeItems(List<JSONArray> cpes) {
        JSONArray mergedJson = new JSONArray();
        HashSet<String> knownIds = new HashSet<String>();
        for (JSONArray array : cpes) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject cve = NvdCpeApiDownload.unwrapCpeEntry(array.getJSONObject(i));
                String id = (String)ObjectUtils.firstNonNull((Object[])new String[]{cve.optString("cpeNameId", null), cve.optString("matchCriteriaId", null)});
                if (knownIds.add(id)) {
                    mergedJson.put((Object)cve);
                    continue;
                }
                if (id == null) {
                    LOG.warn("CPE entry does not provide 'cpeNameId' or 'matchCriteriaId' - skipping: [{}]", (Object)cve);
                    continue;
                }
                LOG.debug("CPE entry with ID [{}] already exists - skipping: [{}]", (Object)id, (Object)cve);
            }
        }
        return mergedJson;
    }

    private JSONObject downloadCpePage(int offset, ResourceLocationNvd baseLocation) {
        URL pageUrl = super.getRemoteResourceLocationUrl(baseLocation, offset);
        List<String> response = this.downloader.fetchResponseBodyFromUrlAsList(pageUrl, Collections.singletonMap("apiKey", this.apiKey));
        try {
            return new JSONObject(String.join((CharSequence)"", response));
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to parse NVD CPE API response: " + response + "\nRequest URL: " + pageUrl, e);
        }
    }

    private JSONObject downloadCpePage(int offset, Date lastModStartDate, Date lastModEndDate, ResourceLocationNvd baseLocation) {
        long diff = lastModEndDate.getTime() - lastModStartDate.getTime();
        if (diff > 10368000000L) {
            throw new IllegalArgumentException("Difference between lastModStartDate and lastModEndDate must not be greater than 120 days");
        }
        String startDate = ISO_8601_DATE_FORMAT.format(lastModStartDate);
        String endDate = ISO_8601_DATE_FORMAT.format(lastModEndDate);
        URL pageUrl = super.getRemoteResourceLocationUrl(baseLocation, offset, startDate, endDate);
        List<String> response = this.downloader.fetchResponseBodyFromUrlAsList(pageUrl, Collections.singletonMap("apiKey", this.apiKey));
        try {
            return new JSONObject(String.join((CharSequence)"", response));
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to parse NVD CVE API response: " + response + "\nRequest URL: " + pageUrl, e);
        }
    }

    private boolean isFullMirrorRequired() {
        File[] downloadFiles = this.downloadIntoDirectory.listFiles();
        if (downloadFiles == null) {
            LOG.info("No CPE JSON files found in download directory, performing full mirror");
            return true;
        }
        List files = Arrays.stream(downloadFiles).map(File::getName).collect(Collectors.toList());
        if (files.stream().noneMatch(file -> file.endsWith(".json"))) {
            LOG.info("No CPE JSON files found in download directory, performing full mirror");
            return true;
        }
        int latestCheckYear = Calendar.getInstance().get(1) - 1;
        for (int year = 2007; year <= latestCheckYear; ++year) {
            if (files.contains(year + ".json")) continue;
            LOG.info("Missing CPE JSON file for year [{}], performing full mirror", (Object)year);
            return true;
        }
        long days120 = 10368000000L;
        long directoryLastModified = this.getDownloadDirectoryLastModified();
        if (super.isUpdatedAgeOlderThan(directoryLastModified, 10368000000L)) {
            LOG.info("Download directory last modified date is older than 120 days, performing full mirror");
            return true;
        }
        return false;
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        Date now;
        if (this.isFullMirrorRequired()) {
            return true;
        }
        long lastModified = this.getDownloadDirectoryLastModified();
        Date lastModifiedDate = new Date(lastModified);
        JSONObject changesMatch = this.downloadCpePage(0, lastModifiedDate, now = new Date(TimeUtils.utcNow()), ResourceLocationNvd.CPE_MATCH_API_START_END_DATE);
        if (changesMatch.has("totalResults") && changesMatch.getInt("totalResults") > 0) {
            LOG.info("NVD CPE Match API reports [{}] new/changed entries since last download", (Object)changesMatch.getInt("totalResults"));
            return true;
        }
        JSONObject changesDict = this.downloadCpePage(0, lastModifiedDate, now, ResourceLocationNvd.CPE_API_START_END_DATE);
        if (changesDict.has("totalResults") && changesDict.getInt("totalResults") > 0) {
            LOG.info("NVD CPE Dictionary API reports [{}] new/changed entries since last download", (Object)changesDict.getInt("totalResults"));
            return true;
        }
        return false;
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationNvd.valueOf(location), url);
    }

    public static enum ResourceLocationNvd implements ResourceLocation
    {
        CPE_API_LIST_ALL("https://services.nvd.nist.gov/rest/json/cpes/2.0?startIndex=%d"),
        CPE_API_START_END_DATE("https://services.nvd.nist.gov/rest/json/cpes/2.0?startIndex=%d&lastModStartDate=%s&lastModEndDate=%s"),
        CPE_MATCH_API_LIST_ALL("https://services.nvd.nist.gov/rest/json/cpematch/2.0?startIndex=%d"),
        CPE_MATCH_API_START_END_DATE("https://services.nvd.nist.gov/rest/json/cpematch/2.0?startIndex=%d&lastModStartDate=%s&lastModEndDate=%s");

        private final String defaultValue;

        private ResourceLocationNvd(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

