/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.other;

import com.metaeffekt.artifact.analysis.utils.ArchiveUtils;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="epss", mavenPropertyName="epssDownload")
public class EpssDownload
extends Download {
    private static final Logger log = LoggerFactory.getLogger(EpssDownload.class);

    public EpssDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, EpssDownload.class);
    }

    @Override
    protected void performDownload() {
        URL epssScoreDownloadUrl = this.getRemoteResourceLocationUrl(ResourceLocationEpss.EPSS_ALL_SCORES_CSV, new Object[0]);
        File downloadIntoFile = this.getDownloadIntoFile();
        this.downloader.fetchResponseBodyFromUrlToFile(epssScoreDownloadUrl, downloadIntoFile);
        ArrayList<String> unpackIssues = new ArrayList<String>();
        if (!ArchiveUtils.unpackIfPossible(downloadIntoFile, super.getDownloadIntoDirectory(), unpackIssues)) {
            log.error("Issue(s) during unpacking of EPSS scores archive from: {}", (Object)downloadIntoFile);
            unpackIssues.forEach(issue -> log.error(" - {}", issue));
            throw new IllegalStateException("Issue(s) during unpacking of EPSS scores archive from: " + downloadIntoFile + "\n - " + String.join((CharSequence)"\n - ", unpackIssues));
        }
        this.propertyFiles.set(super.getDownloadIntoDirectory(), "info", Mirror.InfoFileAttributes.EPSS_PREFIX.getKey() + "resource-size", String.valueOf(downloadIntoFile.length()));
        try {
            FileUtils.delete((File)downloadIntoFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not delete downloaded EPSS scores archive: " + downloadIntoFile, e);
        }
    }

    private File getDownloadIntoFile() {
        return new File(super.getDownloadIntoDirectory(), "epss_scores-current.csv.gz");
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        boolean isNotEqual;
        URL epssScoreDownloadUrl = this.getRemoteResourceLocationUrl(ResourceLocationEpss.EPSS_ALL_SCORES_CSV, new Object[0]);
        long fetchedFileSize = this.downloader.fetchFileSizeFromUrl(epssScoreDownloadUrl, false);
        if (fetchedFileSize < 0L) {
            log.info("Skipping check for EPSS mirror requirement: EPSS scores file size at {} could not be fetched without downloading entire file.", (Object)epssScoreDownloadUrl);
            return false;
        }
        Optional<Long> presentSize = this.propertyFiles.getLong(super.getDownloadIntoDirectory(), "info", Mirror.InfoFileAttributes.EPSS_PREFIX.getKey() + "resource-size");
        if (!presentSize.isPresent()) {
            log.info("EPSS mirror is required: EPSS scores file size at {} is not present. New size: {}", (Object)epssScoreDownloadUrl, (Object)fetchedFileSize);
            this.propertyFiles.set(super.getDownloadIntoDirectory(), "info", Mirror.InfoFileAttributes.EPSS_PREFIX.getKey() + "resource-size", String.valueOf(fetchedFileSize));
            return true;
        }
        boolean bl = isNotEqual = fetchedFileSize != presentSize.get();
        if (isNotEqual) {
            log.info("EPSS mirror is required: EPSS scores file size at {} has changed. Old size: {}, new size: {}", new Object[]{epssScoreDownloadUrl, presentSize.get(), fetchedFileSize});
            this.propertyFiles.set(super.getDownloadIntoDirectory(), "info", Mirror.InfoFileAttributes.EPSS_PREFIX.getKey() + "resource-size", String.valueOf(fetchedFileSize));
        }
        return isNotEqual;
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationEpss.valueOf(location), url);
    }

    public static enum ResourceLocationEpss implements ResourceLocation
    {
        EPSS_ALL_SCORES_CSV("https://epss.cyentia.com/epss_scores-current.csv.gz"),
        EPSS_SPECIFIC_DATE_CSV("https://epss.cyentia.com/epss_scores-%s-%s-%s.csv.gz");

        private final String defaultValue;

        private ResourceLocationEpss(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

