/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.nvd;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.download.nvd.NvdCpeApiDownload;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

@MirrorMetadata(directoryName="cpe-dict", mavenPropertyName="nvdCpeIndex")
public class NvdCpeApiIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCpeApiIndex.class);

    public NvdCpeApiIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdCpeApiIndex.class, Collections.singletonList(NvdCpeApiDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"NvdCpeApiIndex#processFile"})
    protected Map<String, Document> createIndexDocuments() {
        HashMap<String, Document> documents = new HashMap<String, Document>();
        File[] files = this.requiredDownloads[0].listFiles(f -> f.isFile() && f.getName().endsWith(".json"));
        if (files == null) {
            throw new RuntimeException("Unable to list files in " + this.requiredDownloads[0]);
        }
        for (File file : files) {
            this.executor.submit(() -> {
                Map map = documents;
                synchronized (map) {
                    documents.putAll(this.processFile(file));
                }
            });
        }
        this.executor.setSize(6);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for indexing to complete.", e);
        }
        return documents;
    }

    private Map<String, Document> processFile(File file) {
        JSONArray json;
        HashMap<String, Document> documents = new HashMap<String, Document>();
        LOG.info("Processing file {}", (Object)file.getAbsolutePath());
        try {
            json = new JSONArray(String.join((CharSequence)"", FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read yearly NVD document from " + file.getAbsolutePath(), e);
        }
        LOG.info("Processing [{}] entries for file {}", (Object)json.length(), (Object)file.getName());
        for (int i = 0; i < json.length(); ++i) {
            JSONObject entry = json.getJSONObject(i);
            String cpeName = entry.getString("cpeName");
            Document document = CommonEnumerationUtil.parseCpe(cpeName).map(NvdCpeApiIndex::createDocumentFromCpe).orElse(null);
            if (document == null) {
                throw new RuntimeException("Failed to parse CPE " + cpeName);
            }
            String cpeNameId = entry.getString("cpeNameId");
            boolean deprecated = entry.getBoolean("deprecated");
            JSONArray titles = entry.optJSONArray("titles");
            JSONArray references = entry.optJSONArray("refs");
            String lastModified = entry.getString("lastModified");
            String created = entry.getString("created");
            document.add((IndexableField)new TextField("nvdId", cpeNameId, Field.Store.YES));
            document.add((IndexableField)new StringField("deprecated", Boolean.toString(deprecated), Field.Store.YES));
            if (titles != null) {
                document.add((IndexableField)new TextField("titles", titles.toString(), Field.Store.YES));
            }
            if (references != null) {
                document.add((IndexableField)new TextField("references", references.toString(), Field.Store.YES));
            }
            document.add((IndexableField)new StringField("lastModified", lastModified, Field.Store.YES));
            document.add((IndexableField)new StringField("created", created, Field.Store.YES));
            if (documents.containsKey(cpeNameId)) {
                LOG.warn("Duplicate CPE name id [{}]", (Object)cpeNameId);
            }
            documents.put(cpeNameId, document);
        }
        return documents;
    }

    private static Document createDocumentFromCpe(Cpe cpe) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("part", cpe.getPart().getAbbreviation(), Field.Store.YES));
        doc.add((IndexableField)new TextField("vendor", cpe.getVendor(), Field.Store.YES));
        doc.add((IndexableField)new TextField("product", cpe.getProduct(), Field.Store.YES));
        doc.add((IndexableField)new TextField("version", cpe.getVersion(), Field.Store.YES));
        doc.add((IndexableField)new TextField("update", cpe.getUpdate(), Field.Store.YES));
        doc.add((IndexableField)new TextField("edition", cpe.getEdition(), Field.Store.YES));
        doc.add((IndexableField)new TextField("language", cpe.getLanguage(), Field.Store.YES));
        doc.add((IndexableField)new TextField("sw_edition", cpe.getSwEdition(), Field.Store.YES));
        doc.add((IndexableField)new TextField("target_sw", cpe.getTargetSw(), Field.Store.YES));
        doc.add((IndexableField)new TextField("target_hw", cpe.getTargetHw(), Field.Store.YES));
        doc.add((IndexableField)new TextField("other", cpe.getOther(), Field.Store.YES));
        doc.add((IndexableField)new TextField("cpe23Uri", cpe.toCpe23FS(), Field.Store.YES));
        return doc;
    }
}

