/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.other;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.epss.EpssData;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.download.other.EpssDownload;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="epss", mavenPropertyName="epssIndex")
public class EpssIndex
extends Index {
    private static final Logger log = LoggerFactory.getLogger(EpssIndex.class);

    public EpssIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, EpssIndex.class, Collections.singletonList(EpssDownload.class), Collections.emptyList());
    }

    @Override
    protected Map<String, Document> createIndexDocuments() {
        ConcurrentHashMap<String, Document> documents = new ConcurrentHashMap<String, Document>();
        Collection<File> files = super.getAllFilesRecursively(this.requiredDownloads[0]);
        for (File file : files) {
            if (!file.getName().endsWith(".csv")) continue;
            log.info("Processing file: {}", (Object)file.getName());
            try {
                String contents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                contents = contents.substring(contents.indexOf("\n") + 1);
                contents = contents.substring(contents.indexOf("\n") + 1);
                for (String line : contents.split("\n")) {
                    String[] fields = line.split(",");
                    EpssData epssData = new EpssData(fields[0], Float.parseFloat(fields[1]), Float.parseFloat(fields[2]));
                    documents.put(fields[0], epssData.toDocument());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + file.getAbsolutePath(), e);
            }
        }
        return documents;
    }
}

