/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.nvd.CpeDictionaryVendorProductIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CpeDictionaryVendorProductIndexQuery
extends IndexQuery {
    private static final Logger LOG = LoggerFactory.getLogger(CpeDictionaryVendorProductIndexQuery.class);
    private final Map<String, Set<String>> vendorProductsMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> productVendorsMap = new HashMap<String, Set<String>>();

    public CpeDictionaryVendorProductIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CpeDictionaryVendorProductIndex.class);
    }

    public CpeDictionaryVendorProductIndexQuery(CpeDictionaryVendorProductIndex index) {
        super(index);
    }

    public boolean vendorExists(String vendor) {
        return this.index.findDocuments(new IndexSearch().fieldEquals("vendor", vendor).fieldEquals("type", "vp")).size() > 0;
    }

    public boolean productExists(String product) {
        return this.index.findDocuments(new IndexSearch().fieldEquals("product", product).fieldEquals("type", "pv")).size() > 0;
    }

    public Set<String> findVendorsFuzzy(String vendor) {
        return this.index.findDocuments(new IndexSearch().fieldContains("vendor", vendor).fieldEquals("type", "vp")).stream().map(d -> d.get("vendor")).collect(Collectors.toSet());
    }

    public Set<String> findProductsFuzzy(String product) {
        return this.index.findDocuments(new IndexSearch().fieldContains("product", product).fieldEquals("type", "pv")).stream().map(d -> d.get("product")).collect(Collectors.toSet());
    }

    public Set<String> findVendorsForProduct(String product) {
        return this.getProductVendorsMap().getOrDefault(product, Collections.emptySet());
    }

    public Set<String> findProductsForVendor(String vendor) {
        return this.getVendorProductsMap().getOrDefault(vendor, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getVendorProductsMap() {
        Map<String, Set<String>> map = this.vendorProductsMap;
        synchronized (map) {
            if (this.vendorProductsMap.size() == 0) {
                LOG.debug("Building Vendor Products map for the first time");
                this.index.findAndProcessAllDocuments(document -> this.vendorProductsMap.computeIfAbsent(document.get("vendor"), k -> new HashSet()).addAll(Arrays.asList(document.get("product").split(", "))));
            }
        }
        return this.vendorProductsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getProductVendorsMap() {
        Map<String, Set<String>> map = this.productVendorsMap;
        synchronized (map) {
            if (this.productVendorsMap.size() == 0) {
                LOG.debug("Building Product Vendors map for the first time");
                this.index.findAndProcessAllDocuments(document -> this.productVendorsMap.computeIfAbsent(document.get("product"), k -> new HashSet()).addAll(Arrays.asList(document.get("vendor").split(", "))));
            }
        }
        return this.productVendorsMap;
    }
}

