/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareTreeNode;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import com.metaeffekt.mirror.query.VulnerabilityIndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import us.springett.parsers.cpe.Cpe;

public class CustomVulnerabilityIndexQuery
extends VulnerabilityIndexQuery {
    final Map<String, Vulnerability> vulnerabilitiesByName = new HashMap<String, Vulnerability>();
    final Map<String, List<Vulnerability>> vulnerabilitiesByCpeVendorProduct = new HashMap<String, List<Vulnerability>>();

    public CustomVulnerabilityIndexQuery(Collection<File> vulnerabilityFiles) {
        super(null, null);
        for (File file : vulnerabilityFiles) {
            Vulnerability.fromCustomVulnerabilityFileOrDir(file).forEach(this::addVulnerability);
        }
    }

    public CustomVulnerabilityIndexQuery(File vulnerabilityFile) {
        super(null, null);
        Vulnerability.fromCustomVulnerabilityFileOrDir(vulnerabilityFile).forEach(this::addVulnerability);
    }

    public CustomVulnerabilityIndexQuery() {
        super(null, null);
    }

    @Override
    public VulnerabilityTypeIdentifier<?> getVulnerabilityType() {
        return (VulnerabilityTypeIdentifier)VulnerabilityTypeStore.get().fromNameAndImplementation("CUSTOM", "CUSTOM");
    }

    public void addVulnerability(Vulnerability vulnerability) {
        this.vulnerabilitiesByName.put(vulnerability.getId(), vulnerability);
        List allVendorProducts = vulnerability.getVulnerableSoftwareConfigurations().stream().map(VulnerableSoftwareTreeNode::getAllCpes).flatMap(Collection::stream).map(cpe -> cpe.getCpe().getVendor() + ":" + cpe.getCpe().getProduct()).collect(Collectors.toList());
        for (String vp : allVendorProducts) {
            this.vulnerabilitiesByCpeVendorProduct.computeIfAbsent(vp, k -> new ArrayList()).add(vulnerability);
        }
    }

    @Override
    public List<Vulnerability> findAll() {
        return new ArrayList<Vulnerability>(this.vulnerabilitiesByName.values());
    }

    @Override
    public Optional<Vulnerability> findVulnerabilityByName(String name) {
        return Optional.ofNullable(this.vulnerabilitiesByName.get(name));
    }

    @Override
    public List<Vulnerability> findVulnerabilitiesByFlatAffectedConfiguration(Cpe cpe) {
        if (cpe == null) {
            return new ArrayList<Vulnerability>();
        }
        return this.vulnerabilitiesByCpeVendorProduct.getOrDefault(cpe.getVendor() + ":" + cpe.getProduct(), Collections.emptyList()).stream().filter(v -> v.cpeFlatMatchesVulnerableSoftware(cpe)).distinct().sorted(Vulnerability.COMPARE_BY_NAME).collect(Collectors.toList());
    }

    @Override
    public Map<Vulnerability, VulnerableSoftwareVersionRangeCpe> findVulnerabilitiesByFlatAffectedConfigurationRetainSource(Cpe cpe) {
        if (cpe == null) {
            return new HashMap<Vulnerability, VulnerableSoftwareVersionRangeCpe>();
        }
        return this.vulnerabilitiesByCpeVendorProduct.getOrDefault(cpe.getVendor() + ":" + cpe.getProduct(), Collections.emptyList()).stream().map(v -> Pair.of((Object)v, (Object)v.getCpeFlatMatchedVulnerableSoftware(cpe))).filter(p -> p.getRight() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }
}

