/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaEcosystem;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.advisor.GhsaAdvisorIndex;
import com.metaeffekt.mirror.query.AdvisorIndexQuery;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class GhsaAdvisorIndexQuery
extends AdvisorIndexQuery<GhsaAdvisorEntry> {
    public GhsaAdvisorIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, GhsaAdvisorIndex.class);
    }

    @Override
    protected GhsaAdvisorEntry createAdvisoryEntry(Document document) {
        return GhsaAdvisorEntry.fromDocument(document);
    }

    private String normalizeVsNameForLuceneIndexTokenizer(String name) {
        return String.join((CharSequence)" ", name.split("[.:-]"));
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByVsMaven(Artifact originArtifact, String groupId, String artifactId, Version version, boolean githubReviewed) {
        IndexSearch searcher = new IndexSearch().fieldContains("vulnerableSoftware", GhsaEcosystem.MAVEN.getName());
        if (StringUtils.hasText(groupId)) {
            searcher.fieldContains("vulnerableSoftwareNamePhrases", this.normalizeVsNameForLuceneIndexTokenizer(groupId));
        }
        if (StringUtils.hasText(artifactId)) {
            searcher.fieldContains("vulnerableSoftwareNamePhrases", this.normalizeVsNameForLuceneIndexTokenizer(artifactId));
        }
        if (githubReviewed) {
            searcher.fieldContains("githubReviewed", "true");
        }
        List<Document> documents = this.index.findDocuments(searcher);
        HashMap<GhsaAdvisorEntry, DataSourceIndicator> result = new HashMap<GhsaAdvisorEntry, DataSourceIndicator>();
        for (Document indexableFields : documents) {
            GhsaAdvisorEntry entry = this.createAdvisoryEntry(indexableFields);
            entry.getVulnerableSoftwares().stream().filter(e -> !(!e.getEcosystem().equals(GhsaEcosystem.MAVEN.getName()) || groupId != null && !StringUtils.equals(e.getMavenGroupId(), groupId) || artifactId != null && !StringUtils.equals(e.getMavenArtifactId(), artifactId) || version != null && !e.matches(version))).findFirst().ifPresent(e -> result.put(entry, DataSourceIndicator.ghsa(originArtifact, e.toString())));
        }
        return result;
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByArtifactIdAndVersionInEcosystem(Artifact originArtifact, GhsaEcosystem ecosystem, String artifactId, Version version, boolean githubReviewed) {
        IndexSearch searcher = new IndexSearch().fieldContains("vulnerableSoftware", ecosystem.getName());
        if (StringUtils.hasText(artifactId)) {
            searcher.fieldContains("vulnerableSoftwareNamePhrases", this.normalizeVsNameForLuceneIndexTokenizer(artifactId));
        }
        if (githubReviewed) {
            searcher.fieldContains("githubReviewed", "true");
        }
        HashMap<GhsaAdvisorEntry, DataSourceIndicator> result = new HashMap<GhsaAdvisorEntry, DataSourceIndicator>();
        for (Document indexableFields : this.index.findDocuments(searcher)) {
            GhsaAdvisorEntry entry = this.createAdvisoryEntry(indexableFields);
            entry.getVulnerableSoftwares().stream().filter(e -> !(!e.getEcosystem().equals(ecosystem.getName()) || artifactId != null && !artifactId.equalsIgnoreCase(e.getName()) || version != null && !e.matches(version))).findFirst().ifPresent(e -> result.put(entry, DataSourceIndicator.ghsa(originArtifact, e.toString())));
        }
        return result;
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByNpm(Artifact originArtifact, String artifactId, Version version, boolean githubReviewed) {
        return this.findByArtifactIdAndVersionInEcosystem(originArtifact, GhsaEcosystem.NPM, artifactId, version, githubReviewed);
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByRubyGem(Artifact originArtifact, String artifactId, Version version, boolean githubReviewed) {
        return this.findByArtifactIdAndVersionInEcosystem(originArtifact, GhsaEcosystem.RUBY_GEMS, artifactId, version, githubReviewed);
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByPythonPip(Artifact originArtifact, String artifactId, Version version, boolean githubReviewed) {
        return this.findByArtifactIdAndVersionInEcosystem(originArtifact, GhsaEcosystem.PY_PI, artifactId, version, githubReviewed);
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByNuGet(Artifact originArtifact, String artifactId, Version version, boolean githubReviewed) {
        return this.findByArtifactIdAndVersionInEcosystem(originArtifact, GhsaEcosystem.NU_GET, artifactId, version, githubReviewed);
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByHex(Artifact originArtifact, String artifactId, Version version, boolean githubReviewed) {
        return this.findByArtifactIdAndVersionInEcosystem(originArtifact, GhsaEcosystem.HEX, artifactId, version, githubReviewed);
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByCratesIo(Artifact originArtifact, String artifactId, Version version, boolean githubReviewed) {
        return this.findByArtifactIdAndVersionInEcosystem(originArtifact, GhsaEcosystem.CRATES_IO, artifactId, version, githubReviewed);
    }

    public Map<GhsaAdvisorEntry, DataSourceIndicator> findByAnyEcosystem(Artifact originArtifact, String artifactId, Version version, boolean githubReviewed) {
        IndexSearch searcher = new IndexSearch();
        if (StringUtils.hasText(artifactId)) {
            searcher.fieldContains("vulnerableSoftwareNamePhrases", this.normalizeVsNameForLuceneIndexTokenizer(artifactId));
        }
        if (githubReviewed) {
            searcher.fieldContains("githubReviewed", "true");
        }
        HashMap<GhsaAdvisorEntry, DataSourceIndicator> result = new HashMap<GhsaAdvisorEntry, DataSourceIndicator>();
        for (Document indexableFields : this.index.findDocuments(searcher)) {
            GhsaAdvisorEntry entry = this.createAdvisoryEntry(indexableFields);
            entry.getVulnerableSoftwares().stream().filter(e -> !(artifactId != null && !artifactId.equalsIgnoreCase(e.getName()) || version != null && !e.matches(version))).findFirst().ifPresent(e -> result.put(entry, DataSourceIndicator.ghsa(originArtifact, e.toString())));
        }
        return result;
    }
}

