/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.advisor.MsrcAdvisorIndex;
import com.metaeffekt.mirror.query.AdvisorIndexQuery;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;

public class MsrcAdvisorIndexQuery
extends AdvisorIndexQuery<MsrcAdvisorEntry> {
    public MsrcAdvisorIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcAdvisorIndex.class);
    }

    public MsrcAdvisorIndexQuery(MsrcAdvisorIndex index) {
        super(index);
    }

    @Override
    public MsrcAdvisorEntry findById(String id) {
        boolean isAdv = id.contains("ADV");
        id = id.replaceAll("(MSRC-)?(CVE|CAN)-?", "").replaceAll(".*?(\\d{1,4})-(\\d+).*", "$1-$2").replace("ADV", "");
        id = isAdv ? "ADV" + id : "MSRC-CVE-" + id;
        id = id.replaceAll("-+", "-");
        return (MsrcAdvisorEntry)super.findById(id);
    }

    public List<MsrcAdvisorEntry> findByProduct(MsrcProduct product) {
        return this.findByProduct(product.getId());
    }

    public List<MsrcAdvisorEntry> findByProduct(String productId) {
        return this.index.findDocuments(new IndexSearch().fieldContains("affectedProducts", productId)).stream().map(this::createAdvisoryEntry).filter(e -> e.getAffectedProducts().contains(productId)).collect(Collectors.toList());
    }

    public List<MsrcAdvisorEntry> findAdvisorsByMsrcRemediationSupersededByKbId(String kbIdentifier) {
        String pureIdentifier = kbIdentifier.startsWith("KB") ? kbIdentifier.substring(2) : kbIdentifier;
        return this.index.findDocuments(new IndexSearch().fieldContains("msRemediations", pureIdentifier)).stream().map(this::createAdvisoryEntry).filter(e -> e.getMsRemediations().stream().anyMatch(r -> r.getDescription().equals(pureIdentifier))).collect(Collectors.toList());
    }

    @Override
    protected MsrcAdvisorEntry createAdvisoryEntry(Document document) {
        return MsrcAdvisorEntry.fromDocument(document);
    }
}

