/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.resource;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.inventory.processor.writer.InventoryWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryResource
extends Resource {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryResource.class);
    private final File file;
    private final Inventory providedInventory;
    private Inventory loadedInventory;

    public InventoryResource(File file, Inventory inventory) {
        this.file = file;
        this.providedInventory = inventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inventory getInventory() {
        InventoryResource inventoryResource = this;
        synchronized (inventoryResource) {
            if (this.loadedInventory == null) {
                this.loadedInventory = this.providedInventory != null ? this.providedInventory : this.reloadInventory();
            }
        }
        return this.loadedInventory;
    }

    @Override
    public void sync() throws IOException {
        if (!this.file.exists()) {
            FileUtils.forceMkdirParent((File)this.file);
        }
        new InventoryWriter().writeInventory(this.getInventory(), this.file);
    }

    @Override
    public void sync(File targetFile) throws IOException {
        if (targetFile.getParentFile() != null && !targetFile.getParentFile().exists()) {
            FileUtils.forceMkdirParent((File)targetFile);
        }
        new InventoryWriter().writeInventory(this.getInventory(), targetFile);
    }

    public Map<String, Artifact> buildQualifierArtifactMap() {
        Inventory inventory = this.getInventory();
        LinkedHashMap<String, Artifact> qualifierArtifactMap = new LinkedHashMap<String, Artifact>();
        for (Artifact artifact : inventory.getArtifacts()) {
            String artifactQualifier = this.qualifierOf(artifact);
            if (!qualifierArtifactMap.containsKey(artifactQualifier)) {
                qualifierArtifactMap.put(artifactQualifier, artifact);
                continue;
            }
            throw new IllegalStateException(String.format("Duplicate artifact qualifier detected in inventory [%s]. Qualifier: [%s]", this.getFile(), artifactQualifier));
        }
        return qualifierArtifactMap;
    }

    public String qualifierOf(Artifact artifact) {
        return "[" + artifact.getId() + "-" + artifact.getChecksum() + "-" + artifact.getGroupId() + "-" + artifact.getVersion() + "]";
    }

    public Inventory reloadInventory() {
        if (this.file != null && this.file.exists()) {
            try {
                return new InventoryReader().readInventory(this.file);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load inventory from file: [" + this.file.getAbsolutePath() + "]", e);
            }
        }
        return new Inventory();
    }

    public static InventoryResource attachFile(File inventoryFile) {
        return new InventoryResource(inventoryFile, null);
    }

    public static InventoryResource fromFile(File inventoryFile) {
        InventoryResource.validateInventoryFile(inventoryFile);
        return new InventoryResource(inventoryFile, null);
    }

    private static void validateInventoryFile(File inventoryFile) {
        if (!inventoryFile.exists()) {
            throw new IllegalStateException(String.format("Inventory file [%s] does not exist.", inventoryFile));
        }
    }

    public static InventoryResource fromInventory(Inventory inventory) {
        return new InventoryResource(null, inventory);
    }

    public static InventoryResource create() {
        return new InventoryResource(null, null);
    }

    public void syncIfPossible(File inventoryFile) {
        try {
            this.sync(inventoryFile);
        }
        catch (IOException e) {
            LOG.warn(String.format("Cannot write inventory from [%s].", inventoryFile));
        }
    }

    public File getFile() {
        return this.file;
    }
}

