/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import lombok.Getter;

import java.io.File;

public class DocumentFlowParam extends ConfiguredFlowParam<DocumentFlowParam> {

    private File documentControlFile;

    private File scannerOutputBaseDir;

    private String scannerInventoryOutputPattern;

    private File documentOutputBaseDir;

    private File tmpBaseDir;

    private File referenceInventoryDir;

    private String referenceInventoryIncludes;

    @Getter
    private NormalizationMetaData normalizationMetaData;

    @Getter
    private LicenseTextProvider licenseTextProvider;

    public DocumentFlowParam() {
    }

    public DocumentFlowParam withDocumentControl(File documentControl) {
        this.documentControlFile = documentControl;
        return this;
    }

    public File getDocumentControlFile() {
        return documentControlFile;
    }

    public DocumentFlowParam useScannerOutputDir(File scannerOutputBaseDir) {
        this.scannerOutputBaseDir = scannerOutputBaseDir;
        return this;
    }

    public DocumentFlowParam useScannerInventoryOutputPattern(String scannerInventoryOutputPattern) {
        this.scannerInventoryOutputPattern = scannerInventoryOutputPattern;
        return this;
    }

    public DocumentFlowParam publishResultsTo(File documentOutputBaseDir) {
        this.documentOutputBaseDir = documentOutputBaseDir;
        return this;
    }

    public DocumentFlowParam useTempBaseDir(File tmpBaseDir) {
        this.tmpBaseDir = tmpBaseDir;
        return this;
    }

    public DocumentFlowParam withReferenceInventory(File referenceInventoryDir, String referenceInventoryIncludes) {
        this.referenceInventoryDir = referenceInventoryDir;
        this.referenceInventoryIncludes = referenceInventoryIncludes;
        return this;
    }

    public DocumentFlowParam using(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
        return this;
    }

    public DocumentFlowParam using(LicenseTextProvider licenseTextProvider) {
        this.licenseTextProvider = licenseTextProvider;
        return this;
    }

    public File getDocumentOutputBaseDir() {
        return documentOutputBaseDir;
    }

    public File getTmpBaseDir() {
        return tmpBaseDir;
    }

    public String getScannerInventoryOutputPattern() {
        return scannerInventoryOutputPattern;
    }

    public File getScannerOutputBaseDir() {
        return scannerOutputBaseDir;
    }

    public File getReferenceInventoryDir() {
        return referenceInventoryDir;
    }

    public String getReferenceInventoryIncludes() {
        return referenceInventoryIncludes;
    }

}
