/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow;

import java.io.File;
import java.util.function.Consumer;

public class ObserveFolderFlowParam extends ConfiguredFlowParam<ObserveFolderFlowParam> {

    private File observationDir;
    private File statusBaseDir;
    private File tmpBaseDir;

    private Consumer<File> consumer;

    public ObserveFolderFlowParam(File observationDir, File statusBaseDir, File tmpBaseDir, Consumer<File> consumer) {
        super();
        this.observationDir = observationDir;
        this.statusBaseDir = statusBaseDir;
        this.tmpBaseDir = tmpBaseDir;
        this.consumer = consumer;
    }

    public File getObservationDir() {
        return observationDir;
    }

    public File getStatusBaseDir() {
        return statusBaseDir;
    }

    public File getTmpBaseDir() {
        return tmpBaseDir;
    }

    public int getDelayInSeconds() {
        return Integer.parseInt(getPropertyProvider().getProperty("workbench.observe.folder.delay", "10"));
    }

    public Consumer<File> getConsumer() {
        return consumer;
    }

    public int getNumThreads() {
        return Integer.parseInt(getPropertyProvider().getProperty("workbench.observe.folder.threads", "4"));
    }

}
