/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.resource.InventoryResource;
import lombok.Getter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;

public class SpdxDocumentFlowParam extends ConfiguredFlowParam<ScanFlowParam> {

    @Getter
    private NormalizationMetaData normalizationMetaData;

    @Getter
    private LicenseTextProvider licenseTextProvider;

    @Getter
    private DocumentSpec documentSpec;

    @Getter
    private InventoryResource inventoryResource;

    @Getter
    File targetSpdxFile;

    private static final Logger LOG = LoggerFactory.getLogger(SpdxDocumentFlowParam.class);

    public static SpdxDocumentFlowParam build() {
        return new SpdxDocumentFlowParam();
    }

    public SpdxDocumentFlowParam using(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
        return this;
    }

    public SpdxDocumentFlowParam using(LicenseTextProvider licenseTextProvider) {
        this.licenseTextProvider = licenseTextProvider;
        return this;
    }

    public SpdxDocumentFlowParam documenting(DocumentSpec documentSpec) {
        this.documentSpec = documentSpec;
        return this;
    }

    public SpdxDocumentFlowParam writing(File targetSpdxFile) {
        this.targetSpdxFile = targetSpdxFile;
        return this;
    }

    public SpdxDocumentFlowParam using(InventoryResource inventoryResource) {
        this.inventoryResource = inventoryResource;
        return this;
    }

}
