/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import java.util.Objects;

/**
 * These parameters (notably the defaults posed here) make up a core part of content encryption.
 * <br>
 * The member fields specify how content is encrypted. Should be an AEAD scheme with good security margins.
 * <br>
 * Only modify these if you know what you are doing and are confident that the change will not cause issues.
 */
public class ContentAlgorithmParam {
    private String algorithm = "AES";
    private String mode = "/EAX/NoPadding";
    private String provider = "BC";

    public ContentAlgorithmParam() {}

    public ContentAlgorithmParam(String algorithm, String mode, String provider) {
        this.algorithm = Objects.requireNonNull(algorithm);
        this.mode = Objects.requireNonNull(mode);
        this.provider = Objects.requireNonNull(provider);
    }

    public String getAlgorithm() {
        return algorithm;
    }

    public String getMode() {
        return mode;
    }

    public String getProvider() {
        return provider;
    }
}
