/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

/**
 * Contains useful constants in production and consumption of our encrypted zip archives.<br>
 * Especially names used for the zip's "entries".
 */
public class EncryptedArchiveConstants {
    private EncryptedArchiveConstants() {}

    /**
     * Encrypted NormalizationMetaData object.
     */
    public static final String DATASET_ENTRY_NAME = "ae-dataset.bin";

    /**
     * The keyslots file for decrypting other files.
     */
    public static final String KEYSLOT_ENTRY_NAME = "ae-dataset-keyslots.ndjson";

    /**
     * Encrypted database of license texts. Currently only for internal use.
     */
    public static final String LICENSE_TEXT_DB_ENTRY_NAME = "ae-license-text-db.bin";

    /**
     * An unencrypted license text. Must contain a license that applies to the archive.
     */
    public static final String LICENSE_ENTRY_NAME = "LICENSE.txt";
}
