/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import java.io.File;

public class KeypairGeneratorSpec {
    private final File keyOutputDir;
    private final String readableIdentifier;
    /**
     * Length of the password for use in keyfile password generation.<br>
     * Should be 24 or more. (Rationale: password generator uses alphabetic ascii
     */
    private final int passwordLength;

    public KeypairGeneratorSpec(File keyOutputDir, String readableIdentifier) {
        this(keyOutputDir, readableIdentifier, 24);
    }

    public KeypairGeneratorSpec(File keyOutputDir, String readableIdentifier, int passwordLength) {
        this.keyOutputDir = keyOutputDir;
        this.readableIdentifier = readableIdentifier;
        this.passwordLength = passwordLength;
    }

    public File getKeyOutputDir() {
        return keyOutputDir;
    }

    public String getReadableIdentifier() {
        return readableIdentifier;
    }

    public int getPasswordLength() {
        return passwordLength;
    }
}
