/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.GenericTmdProducerSpec;

import java.io.File;
import java.util.Objects;

import static com.metaeffekt.artifact.analysis.flow.ng.TermMetaDataProducerSpec.BuildType.DEFAULT;

/**
 * Specific producer spec for producing a terms metadata artifact.<br>
 * This contains an additional attibute BuildType.
 */
public class TermMetaDataProducerSpec extends GenericTmdProducerSpec {

    /**
     * Type of build to do.<br>
     */
    public enum BuildType {
        /**
         * DEFAULT build type. Should be usable for external authorized parties.
         */
        DEFAULT,

        /**
         * INTERNAL build type should ONLY be used for company-internal builds. These may not be distributable.
         */
        INTERNAL
    }

    private final BuildType buildType;

    public TermMetaDataProducerSpec(
            File termsMetaDataBaseDir,
            File allowedUserKeysDir,
            File licenseTextFile,
            File zipOutputFile
    ) {
        this(termsMetaDataBaseDir,
                allowedUserKeysDir,
                licenseTextFile,
                zipOutputFile,
                true
        );
    }

    public TermMetaDataProducerSpec(
            File termsMetaDataBaseDir,
            File allowedUserKeysDir,
            File licenseTextFile,
            File zipOutputFile,
            boolean enableImplicitTest
    ) {
        this(termsMetaDataBaseDir, allowedUserKeysDir, licenseTextFile, zipOutputFile, enableImplicitTest, DEFAULT);
    }

    public TermMetaDataProducerSpec(
            File termsMetaDataBaseDir,
            File allowedUserKeysDir,
            File licenseTextFile,
            File zipOutputFile,
            boolean enableImplicitTest,
            BuildType buildType
    ) {
        super(termsMetaDataBaseDir, allowedUserKeysDir, licenseTextFile, zipOutputFile, enableImplicitTest);

        this.buildType = Objects.requireNonNull(buildType, "buildType must not be null");
    }

    public BuildType getBuildType() {
        return buildType;
    }
}
