/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts.provider;

import com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts.EncryptedTextCollectionReader;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.ProviderParameters;
import com.metaeffekt.artifact.terms.model.LicenseTextEntry;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

/**
 * Provides license texts using an encrypted database (and license key).<br>
 * Wraps {@link EncryptedTextCollectionReader} to provide the provider format.
 */
public class EncryptedLicenseTextProvider implements LicenseTextProvider {

    private final ProviderParameters providerParameters;

    public EncryptedLicenseTextProvider(ProviderParameters providerParameters) {
        this.providerParameters = providerParameters;
    }

    /**
     * Tries to find license texts for the given canonicalNames in an encrypted database.
     * @param canonicalNames the names to look for
     * @return returns a map of pairs of the form canonicalName to LicenseTextEntry.
     */
    @Override
    public Map<String, LicenseTextEntry> resolve(Collection<String> canonicalNames) {
        return new EncryptedTextCollectionReader().findLicenses(providerParameters, new HashSet<>(canonicalNames));
    }

}
