/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.param;

import java.io.File;

import static java.util.Objects.requireNonNull;

/**
 * ProducerSpec for Producers that need a tmd repository.
 */
public class GenericTmdProducerSpec {

    /**
     * Basedir of a terms metadata source repo.<br>
     * In contrast, a packaged TMD is not enough for most producers.
     */
    private final File termsMetaDataBaseDir;

    /**
     * The directory with user key files.<br>
     * All user keys written (directly) to this directory will get a keyslot for decryption.
     */
    private final File allowedUserKeysDir;

    /**
     * A file with license information for the produced encrypted package.<br>
     * It will be included unencrypted to be viewable.
     */
    private final File licenseTextFile;

    /**
     * Where the output zip package will be put.
     */
    private final File zipOutputFile;
    private final boolean enableImplicitTest;

    public GenericTmdProducerSpec(
            final File termsMetaDataBaseDir,
            final File allowedUserKeysDir,
            final File licenseTextFile,
            final File zipOutputFile,
            final boolean enableImplicitTest
    ) {
        this.termsMetaDataBaseDir = requireNonNull(termsMetaDataBaseDir, "termsMetaDataBseDir must not be null");
        this.allowedUserKeysDir = requireNonNull(allowedUserKeysDir, "allowedUserKeysDir must not be null");
        this.licenseTextFile = requireNonNull(licenseTextFile, "licenseTextFile must not be null");
        this.zipOutputFile = requireNonNull(zipOutputFile, "zipOutputFile must be defined");
        this.enableImplicitTest = enableImplicitTest;
    }

    public File getTermsMetaDataBaseDir() {
        return termsMetaDataBaseDir;
    }

    public File getAllowedUserKeysDir() {
        return allowedUserKeysDir;
    }

    public File getLicenseTextFile() {
        return licenseTextFile;
    }

    public File getZipOutputFile() {
        return zipOutputFile;
    }

    public boolean isEnableImplicitTest() {
        return enableImplicitTest;
    }
}
