/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.param;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;

import java.io.File;
import java.util.Objects;

public class NormMetaSupplierParameters extends SupplierParameters {

    private final NormalizationMetaData normalizationMetaData;

    public NormMetaSupplierParameters(ContentAlgorithmParam contentAlgorithmParam,
                                      NormalizationMetaData normalizationMetaData,
                                      File allowedUserKeysDir,
                                      File licenseTextFile,
                                      File zipOutputFile) {
        super(contentAlgorithmParam, allowedUserKeysDir, licenseTextFile, zipOutputFile);
        this.normalizationMetaData = Objects.requireNonNull(normalizationMetaData);
    }

    public NormalizationMetaData getNormalizationMetaData() {
        return normalizationMetaData;
    }
}
