/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.param;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.nio.file.Files;

public class ProviderParameters {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderParameters.class);

    private final ContentAlgorithmParam contentAlgorithmParam;
    private final String password;
    private final File encryptedZipPackage;
    private final File userKeysFile;

    public ProviderParameters(
            ContentAlgorithmParam contentAlgorithmParam,
            String password,
            File userKeysFile,
            File encryptedZipPackage) {

        if (StringUtils.isBlank(password)) {
            LOG.warn("Provided password is blank.");
        }
        if (!Files.isRegularFile(encryptedZipPackage.toPath())) {
            LOG.warn("Dataset package not readable.");
        }
        if (!Files.isRegularFile(userKeysFile.toPath())) {
            LOG.warn("The user keys file is not readable.");
        }

        this.contentAlgorithmParam = contentAlgorithmParam;
        this.password = password;
        this.userKeysFile = userKeysFile;
        this.encryptedZipPackage = encryptedZipPackage;
    }

    public ContentAlgorithmParam getContentAlgorithmParam() {
        return contentAlgorithmParam;
    }

    public String getPassword() {
        return password;
    }

    public File getUserKeysFile() {
        return userKeysFile;
    }

    public File getEncryptedZipPackage() {
        return encryptedZipPackage;
    }
}
