/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.flow.notice;

import com.metaeffekt.artifact.analysis.flow.InventoryResult;
import com.metaeffekt.resource.InventoryResource;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateNoticeParameterFlow {

    private static final Logger LOG = LoggerFactory.getLogger(GenerateNoticeParameterFlow.class);

    public InventoryResult process(GenerateNoticeParameterFlowParam param) {

        LOG.info("Deriving NoticeParameters from scan results...");

        final Inventory inventory = param.getInventoryResource().getInventory();
        try {
            // produce derived notice parameter from analysis folders (primary method)
            final NoticeParameterBuilderAnalysis noticeParameterBuilderAnalysis =
                    new NoticeParameterBuilderAnalysis(param.getNormalizationMetaData());
            noticeParameterBuilderAnalysis.enrichInventoryWithNoticeParameter(inventory);

            // run inventory level generator (secondary method; not overwriting previously generated notice parameters)
            final NoticeParameterBuilderInventory noticeParameterBuilderInventory =
                    new NoticeParameterBuilderInventory(param.getNormalizationMetaData());
            noticeParameterBuilderInventory.enrichInventoryWithNoticeParameter(inventory);

            // run postprocessing (consumed the current notice parameter and consolidates it)
            NoticeParameterPostProcessing noticeParameterPostProcessing = new NoticeParameterPostProcessing();
            noticeParameterPostProcessing.postProcessNoticeParameter(inventory);
        } catch (Exception e) {
            LOG.warn("Cannot generate notice parameter.", e);
        }

        LOG.info("Deriving NoticeParameters from scan results completed.");

        return new InventoryResult(InventoryResource.fromInventory(inventory));
    }

}
