/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.metaeffekt.artifact.analysis.workbench;

import org.metaeffekt.core.inventory.processor.model.Inventory;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class InventoryFilterResult {

    private final List<Inventory> referenceInventories;

    private final Inventory projectInventory;

    private final File targetBaseDir;

    public InventoryFilterResult(Inventory projectInventory, File targetBaseDir) {
        referenceInventories = new ArrayList<>();
        this.projectInventory = projectInventory;
        this.targetBaseDir = targetBaseDir;
    }

    public void addReferenceInventory(Inventory referenceInventory) {
        referenceInventories.add(referenceInventory);
    }

    public List<Inventory> getReferenceInventories() {
        return referenceInventories;
    }

    public Inventory getProjectInventory() {
        return projectInventory;
    }

    public File getTargetBaseDir() {
        return targetBaseDir;
    }
}
