/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.resource.InventoryResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.LicenseData;
import org.metaeffekt.core.inventory.processor.model.ReportData;

public class AttachReportFlow {
    public static final String KEY_CATEGORY_USE_NOT_POSSIBLE = "Keine Nutzung m\u00f6glich";
    public static final String KEY_CATEGORY_USEABLE_WITH_ADDITIONAL_SERVICES = "Nutzung nur mit zus\u00e4tzlichen Services";
    public static final String KEY_CATEGORY_USEABLE_WITH_MAJOR_OBLIGATIONS = "Nutzung mit Ber\u00fccksichtigung wesentlicher Einschr\u00e4nkungen";
    public static final String KEY_CATEGORY_USEABLE_WITH_MINOR_OBLIGATIONS = "Nutzung mit Ber\u00fccksichtigung unwesentlicher Einschr\u00e4nkungen";
    public static final String KEY_LICENSE_COMMENTS = "Kommentare";
    public static final String KEY_ASSESSMENT_PENDING = "Assessment Pending";

    public void attachReport(InventoryResource resource) throws IOException {
        resource.getInventory().getReportData().clear();
        int[] id = new int[]{1};
        HashMap<String, ReportData> licenceToReportDataMap = new HashMap<String, ReportData>();
        HashMap<String, ReportData> commercialLicenceToReportDataMap = new HashMap<String, ReportData>();
        for (Artifact artifact : resource.getInventory().getArtifacts()) {
            AttachReportFlow.reportArtifactsWithoutLicense(resource, artifact, id);
            AttachReportFlow.reportArtifactsWithUnknownLicense(resource, artifact, id);
            AttachReportFlow.reportArtifactsWithKnownButNotAssessedLicense(resource, artifact, id);
            AttachReportFlow.reportArtifactsWithLicenseInCategory(resource, artifact, id, KEY_CATEGORY_USE_NOT_POSSIBLE, "CRITICAL", "ACTIVE", licenceToReportDataMap);
            AttachReportFlow.reportArtifactsWithLicenseInCategory(resource, artifact, id, KEY_CATEGORY_USEABLE_WITH_ADDITIONAL_SERVICES, "HIGH", "ACTIVE", licenceToReportDataMap);
            AttachReportFlow.reportArtifactsWithLicenseInCategory(resource, artifact, id, KEY_CATEGORY_USEABLE_WITH_MAJOR_OBLIGATIONS, "INFO", "PASSIVE", licenceToReportDataMap);
            AttachReportFlow.reportArtifactsWithLicenseInCategory(resource, artifact, id, "Commercial", "CRITICAL", "ACTIVE", commercialLicenceToReportDataMap);
            this.reportArtifactsWithInsufficientLicenseStatus(resource, artifact, id);
            AttachReportFlow.reportMarker(resource, id, artifact, "Incomplete Match Marker", "ACTIVE", "CRITICAL");
            AttachReportFlow.reportMarker(resource, id, artifact, "Not for Redistribution Marker", "ACTIVE", "CRITICAL");
            AttachReportFlow.reportMarker(resource, id, artifact, "Non-commercial Marker", "ACTIVE", "CRITICAL");
            AttachReportFlow.reportMarker(resource, id, artifact, "Commercial Marker", "ACTIVE", "CRITICAL");
            AttachReportFlow.reportMarker(resource, id, artifact, "Written Permission Required Marker", "ACTIVE", "CRITICAL");
            AttachReportFlow.reportMarker(resource, id, artifact, "Proprietary Marker", "EXPLORE", "CRITICAL");
            AttachReportFlow.reportMarker(resource, id, artifact, "Display Obligation Marker", "ACTIVE", "HIGH");
            AttachReportFlow.reportMarker(resource, id, artifact, "EULA Marker", "ACTIVE", "HIGH");
            AttachReportFlow.reportMarker(resource, id, artifact, "Printed Document Attribution Marker", "ACTIVE", "HIGH");
            AttachReportFlow.reportMarker(resource, id, artifact, "Do Not Promote Marker", "PASSIVE", "MEDIUM");
            AttachReportFlow.reportMarker(resource, id, artifact, "Trademark Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Secondary License Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Changed License Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Commercial Trademark Restriction Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Facebook Patent Grant", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Facebook Patent Rights Grant 2.0", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Licensing Option", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Licensing Option Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Patent Information Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "No Eligible Content Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Public Domain Fallback Marker", "PASSIVE", "INFO");
            AttachReportFlow.reportMarker(resource, id, artifact, "Pending License Marker", "PASSIVE", "INFO");
        }
    }

    private void reportArtifactsWithInsufficientLicenseStatus(InventoryResource inventoryResource, Artifact artifact, int[] counter) {
        boolean isComponent = AttachReportFlow.isComponent(artifact);
        if (isComponent) {
            HashSet<String> reportedLicenses = new HashSet<String>();
            List licenses = artifact.getLicenses();
            if (!licenses.isEmpty()) {
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, licenses, "associated", reportedLicenses);
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, inventoryResource.getInventory().getEffectiveLicenses(artifact), "effective", reportedLicenses);
            } else {
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Derived Licenses"), "derived/observed", reportedLicenses);
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Binary Artifact - Derived Licenses"), "derived/binary", reportedLicenses);
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Source Artifact - Derived Licenses"), "derived/source", reportedLicenses);
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Source Archive - Derived Licenses"), "derived/source-archive", reportedLicenses);
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Descriptor - Derived Licenses"), "derived/pom", reportedLicenses);
                AttachReportFlow.reportArtifactsWithInsufficientLicenseStatusInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Package Specified License (mapped)"), "derived/package", reportedLicenses);
            }
        }
    }

    private static void reportMarker(InventoryResource inventoryResource, int[] counter, Artifact artifact, String problematicMarker, String policy, String severity) {
        String markers = artifact.get("Derived Markers");
        if (!StringUtils.isEmpty((String)markers)) {
            List markerList = InventoryUtils.tokenizeLicense((String)markers, (boolean)false, (boolean)true);
            for (String marker : markerList) {
                if (!marker.equals(problematicMarker)) continue;
                AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "Detected marker [" + problematicMarker + "]", "MARKER", severity, policy, problematicMarker);
            }
        }
    }

    private static void reportArtifactsWithoutLicense(InventoryResource inventoryResource, Artifact artifact, int[] counter) {
        if (AttachReportFlow.isComponent(artifact)) {
            boolean hasDetectedLicenses = false;
            hasDetectedLicenses |= StringUtils.hasText((String)artifact.getLicense());
            hasDetectedLicenses |= StringUtils.hasText((String)artifact.get("Derived Licenses"));
            hasDetectedLicenses |= StringUtils.hasText((String)artifact.get("Binary Artifact - Derived Licenses"));
            hasDetectedLicenses |= StringUtils.hasText((String)artifact.get("Source Artifact - Derived Licenses"));
            hasDetectedLicenses |= StringUtils.hasText((String)artifact.get("Source Archive - Derived Licenses"));
            hasDetectedLicenses |= StringUtils.hasText((String)artifact.get("Derived Licenses"));
            hasDetectedLicenses |= StringUtils.hasText((String)artifact.get("Package Specified License (mapped)"));
            if (!(hasDetectedLicenses |= StringUtils.hasText((String)artifact.get("Component Specified License")))) {
                AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "No license identified for component.", "NO-LICENSE", "HIGH", "ACTIVE", null);
            }
        }
    }

    private static void reportArtifactsWithUnknownLicense(InventoryResource inventoryResource, Artifact artifact, int[] counter) {
        boolean isComponent = AttachReportFlow.isComponent(artifact);
        if (isComponent) {
            HashSet<String> reportedLicenses = new HashSet<String>();
            List licenses = artifact.getLicenses();
            if (!licenses.isEmpty()) {
                AttachReportFlow.reportUnknownLicenseInContext(inventoryResource, artifact, counter, licenses, "associated", reportedLicenses);
                AttachReportFlow.reportUnknownLicenseInContext(inventoryResource, artifact, counter, inventoryResource.getInventory().getEffectiveLicenses(artifact), "effective", reportedLicenses);
            } else {
                AttachReportFlow.reportUnknownLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Derived Licenses"), "derived/observed", reportedLicenses);
                AttachReportFlow.reportUnknownLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Binary Artifact - Derived Licenses"), "derived/binary", reportedLicenses);
                AttachReportFlow.reportUnknownLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Source Artifact - Derived Licenses"), "derived/source", reportedLicenses);
                AttachReportFlow.reportUnknownLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Source Archive - Derived Licenses"), "derived/source-archive", reportedLicenses);
                AttachReportFlow.reportUnknownLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Descriptor - Derived Licenses"), "derived/descriptor", reportedLicenses);
            }
        }
    }

    private static void reportArtifactsWithKnownButNotAssessedLicense(InventoryResource inventoryResource, Artifact artifact, int[] counter) {
        boolean isComponent = AttachReportFlow.isComponent(artifact);
        if (isComponent) {
            HashSet<String> reportedLicenses = new HashSet<String>();
            List licenses = artifact.getLicenses();
            if (!licenses.isEmpty()) {
                AttachReportFlow.reportKnownButNotAssessedLicenseInContext(inventoryResource, artifact, counter, licenses, "associated", reportedLicenses);
                AttachReportFlow.reportKnownButNotAssessedLicenseInContext(inventoryResource, artifact, counter, inventoryResource.getInventory().getEffectiveLicenses(artifact), "effective", reportedLicenses);
            } else {
                AttachReportFlow.reportKnownButNotAssessedLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Derived Licenses"), "derived/binary", reportedLicenses);
                AttachReportFlow.reportKnownButNotAssessedLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Binary Artifact - Derived Licenses"), "derived/binary", reportedLicenses);
                AttachReportFlow.reportKnownButNotAssessedLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Source Artifact - Derived Licenses"), "derived/source", reportedLicenses);
                AttachReportFlow.reportKnownButNotAssessedLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Source Archive - Derived Licenses"), "derived/source-archive", reportedLicenses);
                AttachReportFlow.reportKnownButNotAssessedLicenseInContext(inventoryResource, artifact, counter, AttachReportFlow.getLicenses(artifact, "Descriptor - Derived Licenses"), "derived/descriptor", reportedLicenses);
            }
        }
    }

    private static void reportUnknownLicenseInContext(InventoryResource inventoryResource, Artifact artifact, int[] counter, List<String> licenses, String licenseContext, Set<String> reportedLicenses) {
        for (String license : licenses) {
            String unknownLicenseTypeMarker;
            LicenseData licenseData;
            if (reportedLicenses.contains(license)) continue;
            reportedLicenses.add(license);
            if (license.contains(" + ") || license.contains("(undefined") || (licenseData = inventoryResource.getInventory().findMatchingLicenseData(license)) == null || !"x".equalsIgnoreCase(unknownLicenseTypeMarker = licenseData.get("Unknown License Type"))) continue;
            AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "Unknown (" + licenseContext + ") license [" + license + "] detected.", "UNKNOWN-LICENSE", "CRITICAL", "ACTIVE", license);
        }
    }

    private static void reportArtifactsWithInsufficientLicenseStatusInContext(InventoryResource inventoryResource, Artifact artifact, int[] counter, List<String> licenses, String licenseContext, Set<String> reportedLicenses) {
        for (String license : licenses) {
            String osiStatus;
            LicenseData licenseData;
            if (reportedLicenses.contains(license)) continue;
            reportedLicenses.add(license);
            if (license.contains(" + ") || license.contains("(undefined") || (licenseData = inventoryResource.getInventory().findMatchingLicenseData(license)) == null) continue;
            String openCodeStatus = licenseData.get("Open CoDE Status");
            if (!"approved".equalsIgnoreCase(openCodeStatus)) {
                if ("not approved".equalsIgnoreCase(openCodeStatus)) {
                    AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "Detected not Open CoDE approved (" + licenseContext + ") license [" + license + "].", "NOT-APPROVED-LICENSE-OPEN-CODE", "HIGH", "ACTIVE", license);
                } else {
                    AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "Detected (" + licenseContext + ") license [" + license + "] without Open CoDE status.", "MISSING-OPEN-CODE-LICENSE-STATUS", "MEDIUM", "REQUEST", license);
                }
            }
            if ((osiStatus = licenseData.get("OSI Statuss")) == null || "approved".equalsIgnoreCase(osiStatus.trim())) continue;
            AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "Detected not OSI approved (" + licenseContext + ") license [" + license + "]. Current status [" + osiStatus + "].", "NOT-APPROVED-LICENSE-OSI", "MEDIUM", "PASSIVE", license);
        }
    }

    private static void reportKnownButNotAssessedLicenseInContext(InventoryResource inventoryResource, Artifact artifact, int[] counter, List<String> licenses, String licenseContext, Set<String> reportedLicenses) {
        for (String license : licenses) {
            boolean unknown;
            LicenseData licenseData;
            if (reportedLicenses.contains(license)) continue;
            reportedLicenses.add(license);
            if (license.contains(" + ") || license.contains("(undefined") || (licenseData = inventoryResource.getInventory().findMatchingLicenseData(license)) == null) continue;
            boolean assessed = "x".equalsIgnoreCase(licenseData.get(KEY_CATEGORY_USEABLE_WITH_ADDITIONAL_SERVICES));
            assessed |= "x".equalsIgnoreCase(licenseData.get(KEY_CATEGORY_USEABLE_WITH_MAJOR_OBLIGATIONS));
            assessed |= "x".equalsIgnoreCase(licenseData.get(KEY_CATEGORY_USEABLE_WITH_MINOR_OBLIGATIONS));
            if ((assessed |= "x".equalsIgnoreCase(licenseData.get(KEY_CATEGORY_USE_NOT_POSSIBLE))) || (unknown = "x".equalsIgnoreCase(licenseData.get("Unknown License Type")))) continue;
            AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "Not assessed (" + licenseContext + ") license [" + license + "] detected.", "NOT-ASSESSED-LICENSE", "HIGH", "ACTIVE", license);
        }
    }

    private static boolean isComponent(Artifact artifact) {
        String type = artifact.get("Type");
        String suffix = artifact.getType();
        return !StringUtils.isEmpty((String)type) || "jar".equalsIgnoreCase(suffix) || "war".equalsIgnoreCase(suffix) || "sar".equalsIgnoreCase(suffix) || "ear".equalsIgnoreCase(suffix);
    }

    private static void reportArtifactsWithLicenseInCategory(InventoryResource inventoryResource, Artifact artifact, int[] counter, String category, String severity, String policy, Map<String, ReportData> licenceToReportDataMap) {
        Set assetIds = InventoryUtils.collectAssetIdsFromAssetMetaData((Inventory)inventoryResource.getInventory());
        List licenses = artifact.getLicenses();
        if (!licenses.isEmpty()) {
            AttachReportFlow.checkAndReportLicensesInCategory(inventoryResource, artifact, counter, category, severity, policy, licenses, "associated", licenceToReportDataMap, assetIds);
            AttachReportFlow.checkAndReportLicensesInCategory(inventoryResource, artifact, counter, category, severity, policy, inventoryResource.getInventory().getEffectiveLicenses(artifact), "effective", licenceToReportDataMap, assetIds);
        } else {
            AttachReportFlow.checkAndReportLicensesInCategory(inventoryResource, artifact, counter, category, severity, policy, AttachReportFlow.getLicenses(artifact, "Derived Licenses"), "derived/binary", licenceToReportDataMap, assetIds);
            AttachReportFlow.checkAndReportLicensesInCategory(inventoryResource, artifact, counter, category, severity, policy, AttachReportFlow.getLicenses(artifact, "Binary Artifact - Derived Licenses"), "derived/binary", licenceToReportDataMap, assetIds);
            AttachReportFlow.checkAndReportLicensesInCategory(inventoryResource, artifact, counter, category, severity, policy, AttachReportFlow.getLicenses(artifact, "Source Artifact - Derived Licenses"), "derived/source", licenceToReportDataMap, assetIds);
            AttachReportFlow.checkAndReportLicensesInCategory(inventoryResource, artifact, counter, category, severity, policy, AttachReportFlow.getLicenses(artifact, "Source Archive - Derived Licenses"), "derived/source-archive", licenceToReportDataMap, assetIds);
            AttachReportFlow.checkAndReportLicensesInCategory(inventoryResource, artifact, counter, category, severity, policy, AttachReportFlow.getLicenses(artifact, "Descriptor - Derived Licenses"), "derived/descriptor", licenceToReportDataMap, assetIds);
        }
    }

    private static List<String> getLicenses(Artifact artifact, String licensesKey) {
        return InventoryUtils.tokenizeLicense((String)artifact.get(licensesKey), (boolean)false, (boolean)false);
    }

    private static void checkAndReportLicensesInCategory(InventoryResource inventoryResource, Artifact artifact, int[] counter, String category, String severity, String policy, List<String> licenses, String licenseContext, Map<String, ReportData> reportedMap, Set<String> assetIds) {
        for (String canonicalLicenseName : licenses) {
            ReportData reportData;
            String qualifier = category + "-" + canonicalLicenseName + "-" + artifact.getId() + "-" + artifact.getGroupId() + "-" + artifact.getVersion();
            LicenseData licenseData = inventoryResource.getInventory().findMatchingLicenseData(canonicalLicenseName);
            if (licenseData == null || !"x".equalsIgnoreCase(licenseData.get(category))) continue;
            if (!reportedMap.containsKey(qualifier)) {
                reportData = AttachReportFlow.reportIssueItem(inventoryResource, artifact, counter, "Categorized (" + licenseContext + ") license [" + canonicalLicenseName + "] in category [" + category + "].", "LICENSE-ISSUE", severity, policy, canonicalLicenseName);
                reportedMap.put(qualifier, reportData);
            }
            reportData = reportedMap.get(qualifier);
            AttachReportFlow.applyAssetMarkers(artifact, reportData, assetIds);
        }
    }

    private static ReportData reportIssueItem(InventoryResource inventoryResource, Artifact artifact, int[] counter, String cause, String idPart, String severity, String policy, String licenseOrMarker) {
        ReportData reportData = new ReportData();
        Object[] objectArray = new Object[1];
        int n = counter[0];
        counter[0] = n + 1;
        objectArray[0] = n;
        reportData.set("Id", String.format("%04d", objectArray));
        reportData.set("Type", idPart);
        reportData.set("Artifact Id", artifact.getId());
        reportData.set("Artifact GroupId", artifact.getGroupId());
        reportData.set("Artifact Version", artifact.getVersion());
        reportData.set("Cause", cause);
        reportData.set("Severity", severity);
        reportData.set("Policy", policy);
        Set assetIds = InventoryUtils.collectAssetIdsFromAssetMetaData((Inventory)inventoryResource.getInventory());
        AttachReportFlow.applyAssetMarkers(artifact, reportData, assetIds);
        reportData.set("License / Marker", licenseOrMarker);
        inventoryResource.getInventory().getReportData().add(reportData);
        return reportData;
    }

    private static void applyAssetMarkers(Artifact artifact, ReportData reportData, Set<String> assetIds) {
        for (String assetId : assetIds) {
            String artifactAssetId;
            String assetMarkerForAsset = artifact.get(assetId);
            if (StringUtils.hasText((String)assetMarkerForAsset)) {
                reportData.set(assetId, assetMarkerForAsset);
            }
            if (!assetId.equals(artifactAssetId = InventoryUtils.deriveAssetIdFromArtifact((Artifact)artifact))) continue;
            reportData.set(assetId, "x");
        }
    }

    public static boolean hasCustomerAssessment(LicenseData inputLicenseData) {
        boolean hasAssessment = StringUtils.hasText((String)inputLicenseData.get(KEY_LICENSE_COMMENTS));
        hasAssessment |= StringUtils.hasText((String)inputLicenseData.get(KEY_CATEGORY_USE_NOT_POSSIBLE));
        hasAssessment |= StringUtils.hasText((String)inputLicenseData.get(KEY_CATEGORY_USEABLE_WITH_ADDITIONAL_SERVICES));
        hasAssessment |= StringUtils.hasText((String)inputLicenseData.get(KEY_CATEGORY_USEABLE_WITH_MAJOR_OBLIGATIONS));
        return hasAssessment |= StringUtils.hasText((String)inputLicenseData.get(KEY_CATEGORY_USEABLE_WITH_MINOR_OBLIGATIONS));
    }
}

