/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.flow.AttachReportFlow;
import com.metaeffekt.artifact.analysis.flow.DocumentFlowParam;
import com.metaeffekt.artifact.analysis.flow.DocumentFlowResult;
import com.metaeffekt.artifact.analysis.flow.FormatInventoryFlow;
import com.metaeffekt.artifact.analysis.flow.ScanConsumer;
import com.metaeffekt.artifact.analysis.flow.SpdxDocumentFlow;
import com.metaeffekt.artifact.analysis.flow.notice.GenerateNoticeFlow;
import com.metaeffekt.artifact.analysis.flow.notice.GenerateNoticeFlowParam;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryMergeUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.workbench.LicenseAggregationUtils;
import com.metaeffekt.artifact.analysis.workbench.ProjectInventoryFilter;
import com.metaeffekt.flow.common.AbstractFlow;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventoryInfo;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.metaeffekt.core.util.ExecUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentFlow
extends AbstractFlow {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentFlow.class);
    private static final String KEY_DOCUMENTATION_TEMPLATE = "workbench.documentation.template";
    private static final String KEY_DOCUMENTATION_TEMPLATE_INVENTORY_PATH_PATTERN = "workbench.documentation.template.%s.inventory.path";
    private static final String KEY_DOCUMENTATION_TEMPLATE_RESULTS_PATH_PATTERN = "workbench.documentation.template.%s.results.path";

    public DocumentFlowResult process(DocumentFlowParam documentFlowParam) throws IOException {
        String documentationTemplatePath = documentFlowParam.getPropertyProvider().getProperty(KEY_DOCUMENTATION_TEMPLATE, null);
        if (documentationTemplatePath == null) {
            LOG.info("Skipping documentation. No documentation template defined.");
            return null;
        }
        File documentControlFile = documentFlowParam.getDocumentControlFile();
        if (documentControlFile == null || !documentControlFile.exists()) {
            LOG.info("Skipping documentation. No file [{}] defined.", (Object)documentControlFile);
            return null;
        }
        File scannerOutputBaseDir = documentFlowParam.getScannerOutputBaseDir();
        String scannerOutputInventoryPattern = documentFlowParam.getScannerInventoryOutputPattern();
        File documentOutputBaseDir = documentFlowParam.getDocumentOutputBaseDir();
        File tmpBaseDir = documentFlowParam.getTmpBaseDir();
        File documentationProjectBaseDir = new File(tmpBaseDir, "documentation");
        File documentationTemplateBaseDir = new File(documentationTemplatePath);
        Inventory documentControlInventory = new InventoryReader().readInventory(documentControlFile);
        for (InventoryInfo info : documentControlInventory.getInventoryInfo()) {
            List<File> inventoryFiles;
            String documentId = info.getId();
            File targetProjectBaseDir = new File(documentationProjectBaseDir, documentId);
            String profile = info.get("document.type");
            String templatePathKey = String.format(KEY_DOCUMENTATION_TEMPLATE_RESULTS_PATH_PATTERN, profile);
            String templateDocumentPath = documentFlowParam.getPropertyProvider().getProperty(templatePathKey, null);
            if (templateDocumentPath == null) {
                LOG.warn("No documentation template found for key [{}].", (Object)templatePathKey);
                continue;
            }
            File resultDocumentFile = new File(targetProjectBaseDir, templateDocumentPath);
            File targetDocumentBaseDir = new File(documentOutputBaseDir, documentId);
            String configuredResultFileName = info.get("document.filename.pdf");
            String resultFileName = !StringUtils.isEmpty((String)configuredResultFileName) ? configuredResultFileName : info.get("product.name") + "-" + info.get("product.version") + "-" + info.get("document.name") + ".pdf";
            File targetDocumentFile = new File(targetDocumentBaseDir, resultFileName);
            if (targetDocumentFile.exists() || (inventoryFiles = this.collectInventoryFiles(scannerOutputInventoryPattern, scannerOutputBaseDir, info)).isEmpty()) continue;
            ArrayList<String> commandParts = new ArrayList<String>();
            commandParts.add("mvn");
            commandParts.add("clean");
            commandParts.add("package");
            commandParts.add(String.format("-P %s", profile));
            String documentationTemplateInventoriesPath = documentFlowParam.getPropertyProvider().getProperty(String.format(KEY_DOCUMENTATION_TEMPLATE_INVENTORY_PATH_PATTERN, profile), null);
            for (String key : info.getAttributes()) {
                String value = info.get(key);
                if (!StringUtils.hasText((String)value)) continue;
                commandParts.add(String.format("-D%s=%s", key, value));
            }
            commandParts.add("-Dreference.inventory.dir=" + documentFlowParam.getReferenceInventoryDir().getAbsolutePath());
            commandParts.add("-Dreference.inventory.includes=" + documentFlowParam.getReferenceInventoryIncludes());
            Inventory referenceInventory = InventoryUtils.readInventory((File)documentFlowParam.getReferenceInventoryDir(), (String)documentFlowParam.getReferenceInventoryIncludes());
            FileUtils.deleteDir((File)targetProjectBaseDir);
            FileUtils.copyDirectory((File)documentationTemplateBaseDir, (File)targetProjectBaseDir);
            File targetInventoryDir = new File(targetProjectBaseDir, documentationTemplateInventoriesPath);
            String documentName = targetDocumentFile.getName();
            int lastDotIndex = targetDocumentFile.getName().lastIndexOf(".");
            if (lastDotIndex > 0) {
                documentName = targetDocumentFile.getName().substring(0, lastDotIndex);
            }
            InventoryResource resource = InventoryResource.fromInventory((Inventory)new Inventory());
            new InventoryMergeUtils().merge(inventoryFiles, resource.getInventory());
            ProjectInventoryFilter filter = new ProjectInventoryFilter();
            filter.setEnableUseDerivedLicense(true);
            filter.setEnableApplyCurationData(true);
            filter.process(resource.getInventory(), referenceInventory);
            ScanConsumer.transferBusinessCaseAssessmentData(referenceInventory, resource.getInventory());
            GenerateNoticeFlowParam generateNoticeFlowParam = GenerateNoticeFlowParam.builder().inventoryResource(resource).normalizationMetaData(documentFlowParam.getNormalizationMetaData()).build();
            GenerateNoticeFlow generateNoticeFlow = new GenerateNoticeFlow();
            generateNoticeFlow.process(generateNoticeFlowParam);
            new AttachReportFlow().attachReport(resource);
            new FormatInventoryFlow().filterAndFormat(resource);
            resource.sync(new File(targetInventoryDir, documentName + ".xlsx"));
            LicenseAggregationUtils.copyLicenses(resource.getInventory(), targetDocumentBaseDir, documentFlowParam.getNormalizationMetaData(), documentFlowParam.getLicenseTextProvider(), false);
            resource.sync(new File(targetDocumentBaseDir, documentName + ".xlsx"));
            File targetSpdxDocumentFile = new File(targetDocumentBaseDir, documentName + "-spdx.json");
            SpdxDocumentFlow.produceSpdxDocument(resource, documentName, targetSpdxDocumentFile, documentFlowParam.getNormalizationMetaData(), documentFlowParam.getLicenseTextProvider(), documentFlowParam.getPropertyProvider());
            ExecUtils.ExecParam execParam = new ExecUtils.ExecParam(commandParts);
            execParam.setWorkingDir(targetProjectBaseDir);
            ExecUtils.executeAndThrowIOExceptionOnFailure((ExecUtils.ExecParam)execParam);
            FileUtils.copyFile((File)resultDocumentFile, (File)targetDocumentFile);
        }
        return new DocumentFlowResult();
    }

    protected List<File> collectInventoryFiles(String inventoryPattern, File outputBaseDir, InventoryInfo info) {
        String assets = info.get("Assets");
        String[] strings = FileUtils.scanDirectoryForFolders((File)outputBaseDir, (String[])new String[]{assets});
        HashMap<String, List> assetWithoutTimestampToAssetMap = new HashMap<String, List>();
        for (String assetInventoryName : strings) {
            String assetWithoutTimestamp = assetInventoryName.substring(0, assetInventoryName.lastIndexOf("-"));
            assetWithoutTimestampToAssetMap.computeIfAbsent(assetWithoutTimestamp, n -> new ArrayList()).add(assetInventoryName);
        }
        ArrayList<File> inventoryFiles = new ArrayList<File>();
        for (String assetWithoutTimestamp : assetWithoutTimestampToAssetMap.keySet()) {
            List assetInventoriesInGroup = (List)assetWithoutTimestampToAssetMap.get(assetWithoutTimestamp);
            assetInventoriesInGroup.sort(String.CASE_INSENSITIVE_ORDER);
            String asset = (String)assetInventoriesInGroup.get(assetInventoriesInGroup.size() - 1);
            File scannerResultsDir = new File(outputBaseDir, asset);
            File inventoryFile = FileUtils.findSingleFile((File)scannerResultsDir, (String)inventoryPattern);
            if (inventoryFile == null) continue;
            inventoryFiles.add(inventoryFile);
        }
        return inventoryFiles;
    }
}

