/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow;

import com.metaeffekt.artifact.analysis.flow.ScanFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanFlowResult;
import com.metaeffekt.artifact.analysis.flow.notice.GenerateNoticeParameterFlow;
import com.metaeffekt.artifact.analysis.flow.notice.GenerateNoticeParameterFlowParam;
import com.metaeffekt.artifact.analysis.metascan.CopyrightSegmentationSupport;
import com.metaeffekt.artifact.analysis.metascan.MetaScanSupport;
import com.metaeffekt.artifact.analysis.metascan.SourceSegmentationSupport;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeSupport;
import com.metaeffekt.artifact.analysis.utils.ArchiveUtils;
import com.metaeffekt.artifact.analysis.utils.ConcurrentUtils;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.flow.common.AbstractFlow;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanFlow
extends AbstractFlow {
    private static final Logger LOG = LoggerFactory.getLogger(ScanFlow.class);

    public ScanFlowResult process(ScanFlowParam scanFlowParam) throws IOException {
        ScanSupport scanSupport = new ScanSupport(scanFlowParam);
        return this.process(scanFlowParam, scanSupport);
    }

    private ScanFlowResult process(ScanFlowParam scanFlowParam, ScanSupport scanSupport) throws IOException {
        Inventory inventory = scanFlowParam.getInventoryResource().getInventory();
        int min = Math.min(scanFlowParam.getScanThreads(), inventory.getArtifacts().size());
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(min, 1));
        ConcurrentHashMap exceptions = new ConcurrentHashMap();
        int index = 1;
        int size = inventory.getArtifacts().size();
        for (Artifact artifact : inventory.getArtifacts()) {
            String context = String.format("[%s/%s]", index++, size);
            executor.submit(() -> this.scanArtifact(scanFlowParam, scanSupport, artifact, context));
        }
        ConcurrentUtils.awaitTerminationOrCancelOnException((ExecutorService)executor, exceptions);
        InventoryResource inventoryResource = InventoryResource.fromInventory((Inventory)inventory);
        this.generateNoticeParameters(scanFlowParam, inventoryResource);
        File resultTargetDir = scanFlowParam.getResultTargetDir();
        if (resultTargetDir != null) {
            FileUtils.forceMkDirQuietly((File)resultTargetDir);
            File resultInventory = new File(resultTargetDir, DateTime.now().getMillis() + ".xlsx");
            inventoryResource.sync(resultInventory);
        }
        return new ScanFlowResult(inventory);
    }

    private void generateNoticeParameters(ScanFlowParam scanFlowParam, InventoryResource inventoryResource) {
        if (scanFlowParam.getPropertyProvider().isProperty("analyze.noticeparameter.generate", "true", "true")) {
            GenerateNoticeParameterFlowParam generateNoticeParameterFlowParam = GenerateNoticeParameterFlowParam.builder().inventoryResource(inventoryResource).normalizationMetaData(scanFlowParam.getNormalizationMetaData()).build();
            GenerateNoticeParameterFlow generateNoticeParameterFlow = new GenerateNoticeParameterFlow();
            generateNoticeParameterFlow.process(generateNoticeParameterFlowParam);
        }
    }

    private void scanArtifact(ScanFlowParam scanFlowParam, ScanSupport scanSupport, Artifact inputArtifact, String context) {
        Artifact artifact = new Artifact(inputArtifact);
        try {
            if (scanFlowParam.getPropertyProvider().isProperty("analyze", "true", "true")) {
                if (scanFlowParam.getPropertyProvider().isProperty("analyze.binary.artifact", "true", "true")) {
                    scanSupport.cloneAndScan(scanFlowParam, inputArtifact, "Binary Artifact", artifact, context);
                }
                if (scanFlowParam.getPropertyProvider().isProperty("analyze.source.artifact", "true", "true")) {
                    scanSupport.cloneAndScan(scanFlowParam, inputArtifact, "Source Artifact", artifact, context);
                }
                if (scanFlowParam.getPropertyProvider().isProperty("analyze.source.archive", "true", "true")) {
                    scanSupport.cloneAndScan(scanFlowParam, inputArtifact, "Source Archive", artifact, context);
                }
                if (scanFlowParam.getPropertyProvider().isProperty("analyze.descriptor", "true", "true")) {
                    scanSupport.cloneAndScan(scanFlowParam, inputArtifact, "Descriptor", artifact, context);
                }
                if (scanFlowParam.getPropertyProvider().isProperty("analyze.observed.artifact", "true", "true")) {
                    scanSupport.scanObservedArtifact(scanFlowParam, inputArtifact, artifact, context);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception will executing scan.", (Throwable)e);
        }
        inputArtifact.merge(artifact);
    }

    public static class ScanSupport {
        private static String[] TRANSFER_KEY_SET = new String[]{"Derived Licenses", "Derived Markers", "Derived Notice Parameter", "Extracted Copyrights (ScanCode)", "Extracted Authors (ScanCode)", "Analysis Path"};
        final MetaScanSupport metaScanSupport;
        final SourceSegmentationSupport sourceSegmentationSupport;
        final ScanCodeSupport scanCodeSupport;
        final CopyrightSegmentationSupport copyrightSegmentationSupport;

        public ScanSupport(ScanFlowParam scanFlowParam) {
            NormalizationMetaData normalizationMetaData = scanFlowParam.getNormalizationMetaData();
            PropertyProvider propertyProvider = scanFlowParam.getPropertyProvider();
            this.metaScanSupport = new MetaScanSupport(normalizationMetaData, propertyProvider);
            this.sourceSegmentationSupport = new SourceSegmentationSupport(normalizationMetaData, propertyProvider);
            this.scanCodeSupport = new ScanCodeSupport(propertyProvider);
            this.copyrightSegmentationSupport = new CopyrightSegmentationSupport(normalizationMetaData, propertyProvider);
        }

        public void scan(Artifact artifact, File artifactAnalysisDir, String context) throws IOException {
            this.metaScanSupport.execute(artifact, artifactAnalysisDir, context);
            this.scanCodeSupport.execute(artifact, artifactAnalysisDir);
            this.sourceSegmentationSupport.runSegmentation(artifact, artifactAnalysisDir);
            this.copyrightSegmentationSupport.runSegmentation(artifact, artifactAnalysisDir);
        }

        private void cloneAndScan(ScanFlowParam scanFlowParam, Artifact inputArtifact, String partPrefix, Artifact artifact, String context) {
            try {
                Artifact clone = new Artifact(inputArtifact);
                Arrays.stream(TRANSFER_KEY_SET).forEach(a -> clone.set(a, null));
                Artifact result = this.scanArtifactPath(scanFlowParam, clone, inputArtifact.get(partPrefix + " - Path"), null, partPrefix, context);
                Arrays.stream(TRANSFER_KEY_SET).forEach(a -> this.transferAttributes(result, artifact, partPrefix, (String)a));
            }
            catch (Exception e) {
                LOG.error("Exception during scan of [{}].", (Object)inputArtifact.deriveQualifier(), (Object)e);
            }
        }

        private void transferAttributes(Artifact clone, Artifact artifact, String partPrefix, String key) {
            artifact.set(partPrefix + " - " + key, clone.get(key));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Artifact scanArtifactPath(ScanFlowParam scanFlowParam, Artifact inputArtifact, String archivePath, String archiveContentCheckSumIfAvailable, String part, String context) {
            Artifact artifact = new Artifact(inputArtifact);
            if (StringUtils.notEmpty((String)archivePath)) {
                File archiveFile = new File(archivePath);
                String name = archiveFile.getName();
                File artifactAnalysisDir = this.deriveAnalysisFolder(scanFlowParam.getAnalysisBaseDir(), archiveFile, archiveContentCheckSumIfAvailable);
                artifact.setId(name);
                artifact.set("Archive Path", archivePath);
                artifact.set("Analysis Path", artifactAnalysisDir.getAbsolutePath());
                LOG.info("{} Scanning ({}) [{}]", new Object[]{context, part, artifact.get("Archive Path")});
                LOG.info("{} Scanning ({}) in [{}]", new Object[]{context, part, artifact.get("Analysis Path")});
                String semaphore = this.getClass().getName() + artifactAnalysisDir.getAbsolutePath();
                String string = semaphore.intern();
                synchronized (string) {
                    try {
                        ArchiveUtils.unpackArchiveOrCopyFile((File)archiveFile, (File)artifactAnalysisDir);
                        FileUtils.validateExists((File)artifactAnalysisDir);
                        this.scan(artifact, artifactAnalysisDir, context);
                    }
                    catch (Exception e) {
                        artifact.append("Errors", e.getMessage(), "\n");
                    }
                }
                artifact.set("Analysis Path", artifactAnalysisDir.getAbsolutePath());
            }
            return artifact;
        }

        private File deriveAnalysisFolder(File analysisBaseDir, File partFile, String archiveContentChecksumIfAvailable) {
            String filename = partFile.getName();
            File organizedTargetDir = this.deriveAnalysisFolder(analysisBaseDir, filename);
            String checksum = StringUtils.hasText((String)archiveContentChecksumIfAvailable) ? archiveContentChecksumIfAvailable : FileUtils.computeChecksum((File)partFile);
            return new File(organizedTargetDir, ScanSupport.deriveUnpackTargetFolder(filename, checksum));
        }

        public File deriveAnalysisFolder(File targetBaseDir, String filename) {
            String filenameLowerCase = filename.toLowerCase().trim();
            String noVersionFilename = filenameLowerCase.replaceFirst("-[0-9]+.*", "");
            if (noVersionFilename.isEmpty()) {
                noVersionFilename = filenameLowerCase;
            }
            noVersionFilename = noVersionFilename.replace("/", "_");
            int length = noVersionFilename.length();
            String level1 = "[" + noVersionFilename.substring(0, Math.min(length, 1)) + "]";
            String level2 = "[" + noVersionFilename.substring(0, Math.min(length, 2)) + "]";
            String level3 = "[" + noVersionFilename + "]";
            return new File(new File(new File(targetBaseDir, level1), level2), level3);
        }

        public static String deriveUnpackTargetFolder(String filename, String checksum) {
            filename = filename.replace("/", "_");
            return "[" + filename + "-" + checksum + "]";
        }

        private void scanObservedArtifact(ScanFlowParam scanFlowParam, Artifact inputArtifact, Artifact artifact, String context) {
            try {
                Artifact result = this.scanArtifactPath(scanFlowParam, artifact, inputArtifact.get("Archive Path"), inputArtifact.get("Content Checksum"), "observed", context);
                artifact.merge(result);
            }
            catch (Exception e) {
                LOG.error("Exception will executing scan.", (Throwable)e);
            }
        }
    }
}

