/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.metaeffekt.artifact.analysis.flow.ng.KeypairGeneratorSpec;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForConsumer;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForSupplier;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysStorage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeypairGenerator {
    private static final BigInteger publicExponent = BigInteger.valueOf(65535L);
    private static final int keySize = 4096;
    public static final String supplierKeysFileEnding = ".supplier.keys.json";
    public static final String consumerKeysFileEnding = ".consumer.keys";
    public static final String consumerKeysMetadataFileEnding = ".meta.json";
    private static final Logger LOG = LoggerFactory.getLogger(KeypairGenerator.class);

    public static String generateUserKeysPassword(int length) {
        SecureRandom random = new SecureRandom();
        StringBuilder passwordBuilder = new StringBuilder();
        long failureCounter = 0L;
        long maxFailures = (long)length * 128L;
        while (passwordBuilder.length() < length) {
            int randInt = random.nextInt(256);
            if (97 < randInt && randInt < 122 || 65 < randInt && randInt < 90) {
                passwordBuilder.appendCodePoint(randInt);
                continue;
            }
            if (++failureCounter <= maxFailures) continue;
            throw new RuntimeException("should never happen: failure count exceeded while generating password");
        }
        return passwordBuilder.toString();
    }

    public static Pair<UserKeysForSupplier, UserKeysForConsumer> createUserKeyPair(SecureRandom random) {
        RSAKeyPairGenerator gen = new RSAKeyPairGenerator();
        gen.init((KeyGenerationParameters)new RSAKeyGenerationParameters(publicExponent, random, 4096, 256));
        AsymmetricCipherKeyPair kp = gen.generateKeyPair();
        RSAKeyParameters publicKey = (RSAKeyParameters)kp.getPublic();
        RSAKeyParameters privateKey = (RSAKeyParameters)kp.getPrivate();
        byte[] hmacSecretKey = new byte[32];
        random.nextBytes(hmacSecretKey);
        UserKeysForSupplier keysForSupplier = new UserKeysForSupplier(publicKey, hmacSecretKey);
        UserKeysForConsumer keysForConsumer = new UserKeysForConsumer(privateKey, hmacSecretKey);
        return Pair.of((Object)keysForSupplier, (Object)keysForConsumer);
    }

    public static void writeMetadataFile(String keyUuid, String password, File outputFile) throws IOException {
        HashMap<String, String> interMap = new HashMap<String, String>();
        interMap.put("userPassword", password);
        interMap.put("creationDate", Instant.now().toString());
        interMap.put("keyUuid", keyUuid);
        try (OutputStream fos = Files.newOutputStream(outputFile.toPath(), StandardOpenOption.CREATE_NEW);
             OutputStreamWriter writer = new OutputStreamWriter(fos, StandardCharsets.UTF_8);){
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)writer, interMap);
        }
    }

    public static void generateNewUserKeypair(KeypairGeneratorSpec spec) throws IOException {
        String keyUuid = UUID.randomUUID().toString();
        String consumerKeyfileEncryptionPassword = KeypairGenerator.generateUserKeysPassword(spec.getPasswordLength());
        if (StringUtils.isBlank((String)spec.getReadableIdentifier())) {
            throw new IllegalArgumentException("The readable identifier must not be blank.");
        }
        if (StringUtils.isBlank((String)consumerKeyfileEncryptionPassword)) {
            throw new IllegalArgumentException("Generation requires a non-blank password.");
        }
        if (consumerKeyfileEncryptionPassword.length() < 8) {
            LOG.warn("Password is very short!");
        }
        if (consumerKeyfileEncryptionPassword.length() < 23) {
            LOG.warn("Password doesn't contain good security (should have at least 23 characters, 24 recommended).");
        }
        File identifiableKeyOutputDir = new File(spec.getKeyOutputDir(), spec.getReadableIdentifier());
        File forSupplierDir = new File(identifiableKeyOutputDir, "supplier");
        File forConsumerDir = new File(identifiableKeyOutputDir, "consumer");
        File supplierOutputFile = new File(forSupplierDir, keyUuid + supplierKeysFileEnding);
        File consumerEncryptedOutputFile = new File(forConsumerDir, keyUuid + consumerKeysFileEnding);
        File consumerPasswordOutputFile = new File(forConsumerDir, keyUuid + consumerKeysMetadataFileEnding);
        if (supplierOutputFile.exists()) {
            throw new IllegalStateException("Won't write keys: supplier key file with specified id exists!");
        }
        if (consumerEncryptedOutputFile.exists()) {
            throw new IllegalStateException("Won't write keys: consumer key file with specified id exists!");
        }
        if (consumerPasswordOutputFile.exists()) {
            throw new IllegalStateException("Won't write keys: consumer password file with specified id exists!");
        }
        SecureRandom random = new SecureRandom();
        LOG.info("Beginning generation for uuid '" + keyUuid + "'");
        Pair<UserKeysForSupplier, UserKeysForConsumer> keypair = KeypairGenerator.createUserKeyPair(random);
        UserKeysForSupplier keysForSupplier = (UserKeysForSupplier)keypair.getLeft();
        UserKeysForConsumer keysForConsumer = (UserKeysForConsumer)keypair.getRight();
        LOG.info("Beginning write for uuid '" + keyUuid + "'");
        if (!forSupplierDir.isDirectory() && !forSupplierDir.mkdirs()) {
            LOG.error("Couldn't create dir at '" + forSupplierDir.getPath() + "'.");
            throw new IOException("Could not create forSupplierDir.");
        }
        if (!forConsumerDir.isDirectory() && !forConsumerDir.mkdirs()) {
            LOG.error("Couldn't create dir at '" + forConsumerDir.getPath() + "'.");
            throw new IOException("Could not create forConsumerDir.");
        }
        UserKeysStorage.writeUserKeys(keysForSupplier, supplierOutputFile);
        UserKeysStorage.writeUserKeys(keysForConsumer, consumerKeyfileEncryptionPassword, consumerEncryptedOutputFile);
        KeypairGenerator.writeMetadataFile(keyUuid, consumerKeyfileEncryptionPassword, consumerPasswordOutputFile);
        LOG.info("Successfully wrote key '" + keyUuid + "'");
        UserKeysStorage.readUserKeysForConsumer(consumerEncryptedOutputFile, consumerKeyfileEncryptionPassword, true);
        UserKeysStorage.readUserKeysForPublisher(supplierOutputFile, true);
    }
}

