/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import com.metaeffekt.artifact.analysis.flow.ng.EncryptedArtifactProducerUtils;
import com.metaeffekt.artifact.analysis.flow.ng.KeypairGenerator;
import com.metaeffekt.artifact.analysis.flow.ng.TermMetaDataProducerSpec;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.NormMetaSupplierParameters;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.ProviderParameters;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.tmd.EncryptedTermMetaDataProviderNG;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.tmd.EncryptedTermMetaDataSupplierNG;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForConsumer;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForSupplier;
import com.metaeffekt.artifact.analysis.preprocess.filter.wordlist.WordlistGenerator;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermMetaDataProducer {
    private static final Logger LOG = LoggerFactory.getLogger(TermMetaDataProducer.class);

    public static void produce(TermMetaDataProducerSpec spec) throws Exception {
        File tempDir = Files.createTempDirectory("tmdGenerate-tempKeys-", new FileAttribute[0]).toFile();
        FileUtils.forceDeleteOnExit((File)tempDir);
        File dummyDecryptionKeysDir = new File(tempDir, "decryptionTestKeys");
        File allowedKeysWithDummy = new File(tempDir, "allowedKeys");
        File dummyZipOutputFile = new File(tempDir, "terms-metadata");
        SecureRandom random = new SecureRandom();
        File dummyKeyForUser = null;
        String temporaryPassword = null;
        if (spec.isEnableImplicitTest()) {
            Pair<UserKeysForSupplier, UserKeysForConsumer> keypair = KeypairGenerator.createUserKeyPair(random);
            UserKeysForSupplier keysForSupplier = (UserKeysForSupplier)keypair.getLeft();
            UserKeysForConsumer keysForConsumer = (UserKeysForConsumer)keypair.getRight();
            File dummyKeyForPublisher = new File(allowedKeysWithDummy, "dummyKeyForPublisher.tmp.json");
            dummyKeyForUser = new File(dummyDecryptionKeysDir, "dummyKeyForUser.tmp.json");
            temporaryPassword = KeypairGenerator.generateUserKeysPassword(64);
            EncryptedArtifactProducerUtils.writeDummyKeys(dummyKeyForPublisher, dummyKeyForUser, keysForSupplier, keysForConsumer, temporaryPassword);
        }
        if (dummyKeyForUser == null) {
            throw new IllegalStateException();
        }
        NormalizationMetaData normalizationMetaData = new NormalizationMetaData(spec.getTermsMetaDataBaseDir());
        normalizationMetaData.generateAndSetWordlist();
        if (spec.getBuildType() != TermMetaDataProducerSpec.BuildType.INTERNAL) {
            LOG.debug("Filtering customer metadata.");
            EncryptedArtifactProducerUtils.filterCustomerMetaData(normalizationMetaData);
        } else {
            LOG.info("Skipping data filtering for type [{}]. Will include customer licenses.", (Object)spec.getBuildType());
        }
        NormMetaSupplierParameters supplierNGParam = new NormMetaSupplierParameters(new ContentAlgorithmParam(), normalizationMetaData, spec.getAllowedUserKeysDir(), spec.getLicenseTextFile(), spec.getZipOutputFile());
        LOG.info("Beginning output of encrypted content.");
        EncryptedTermMetaDataSupplierNG supplier = new EncryptedTermMetaDataSupplierNG();
        supplier.process(supplierNGParam);
        if (spec.isEnableImplicitTest()) {
            LOG.info("Beginning test with dummy key.");
            NormMetaSupplierParameters dummySupplierParam = new NormMetaSupplierParameters(new ContentAlgorithmParam(), normalizationMetaData, allowedKeysWithDummy, spec.getLicenseTextFile(), dummyZipOutputFile);
            EncryptedTermMetaDataSupplierNG dummySupplier = new EncryptedTermMetaDataSupplierNG();
            dummySupplier.process(dummySupplierParam);
            ProviderParameters providerParameters = new ProviderParameters(new ContentAlgorithmParam(), temporaryPassword, dummyKeyForUser, dummyZipOutputFile);
            EncryptedTermMetaDataProviderNG provider = new EncryptedTermMetaDataProviderNG();
            NormalizationMetaData readNormMeta = provider.process(providerParameters);
            EncryptedArtifactProducerUtils.assertEquals(normalizationMetaData.getLicenseNameMap(), readNormMeta.getLicenseNameMap());
            EncryptedArtifactProducerUtils.assertEquals(normalizationMetaData.getLicenseMetaDataMap(), readNormMeta.getLicenseMetaDataMap());
            EncryptedArtifactProducerUtils.assertEquals(normalizationMetaData.getCategoryNameMap(), readNormMeta.getCategoryNameMap());
            Collection generatedWordlist = WordlistGenerator.createWordlist((NormalizationMetaData)normalizationMetaData);
            EncryptedArtifactProducerUtils.assertEquals(readNormMeta.getWordlist().size(), generatedWordlist.size());
            EncryptedArtifactProducerUtils.assertWordlistEquals(readNormMeta.getWordlist(), generatedWordlist);
            List analyzeRead = readNormMeta.analyze("This targetContentFile is under the Apache License 2.0.");
            List analyzeExpected = normalizationMetaData.analyze("This targetContentFile is under the Apache License 2.0.");
            EncryptedArtifactProducerUtils.assertEquals(analyzeExpected, analyzeRead);
            LOG.info("Analysis result: " + analyzeRead);
            LOG.info("Wordlist size: " + (readNormMeta.getWordlist() == null ? "n.a." : Integer.valueOf(readNormMeta.getWordlist().size())));
        } else {
            LOG.warn("Implicit output testing is disabled!");
        }
    }
}

