/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ContentEncryptionKey {
    private final AtomicBoolean burned = new AtomicBoolean(false);
    private byte[] rawContentEncryptionKey;
    private static final int length = 16;

    public ContentEncryptionKey() {
        SecureRandom secureRandom = new SecureRandom();
        this.rawContentEncryptionKey = new byte[16];
        secureRandom.nextBytes(this.rawContentEncryptionKey);
    }

    public synchronized byte[] getRaw() {
        if (this.burned.get()) {
            throw new IllegalStateException("Tried to use object after burning it.");
        }
        return (byte[])this.rawContentEncryptionKey.clone();
    }

    public int getLength() {
        if (this.burned.get()) {
            throw new IllegalStateException("Tried to use object after burning it.");
        }
        return 16;
    }

    public synchronized void burn() {
        this.burned.set(true);
        this.rawContentEncryptionKey = null;
    }
}

