/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import com.metaeffekt.artifact.analysis.flow.ng.StreamReadingUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.zip.ZipInputStream;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.io.input.CloseShieldInputStream;

public class DecryptedEntryInputStream
extends FilterInputStream
implements AutoCloseable {
    private final boolean closeUnderlying;
    private boolean closed = false;
    private final ZipInputStream underlyingZipStream;

    private DecryptedEntryInputStream(ZipInputStream underlyingZipStream, Cipher cipher, boolean closeUnderlying) {
        super(new CipherInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)underlyingZipStream), cipher));
        this.underlyingZipStream = underlyingZipStream;
        this.closeUnderlying = closeUnderlying;
    }

    private static Cipher createDecryptionCipher(ContentAlgorithmParam param, Key key, byte[] iv) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(param.getAlgorithm() + param.getMode(), param.getProvider());
        cipher.init(2, key, new IvParameterSpec(iv));
        return cipher;
    }

    public static DecryptedEntryInputStream createEntryDecryptionInputStream(ZipInputStream zipInputStream, ContentAlgorithmParam algorithmParam, Key contentKey) throws InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException {
        return DecryptedEntryInputStream.createEntryDecryptionInputStream(zipInputStream, algorithmParam, contentKey, false);
    }

    public static DecryptedEntryInputStream createEntryDecryptionInputStream(ZipInputStream zipInputStream, ContentAlgorithmParam algorithmParam, Key contentKey, boolean closeUnderlying) throws IOException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        byte[] iv = new byte[16];
        StreamReadingUtils.readOrThrow(zipInputStream, iv);
        Cipher cipher = DecryptedEntryInputStream.createDecryptionCipher(algorithmParam, contentKey, iv);
        return new DecryptedEntryInputStream(zipInputStream, cipher, closeUnderlying);
    }

    public static void ensureAuthenticated(InputStream zipInputStream, ContentAlgorithmParam param, Key contentKey) throws AEADBadTagException {
        try {
            int readBytes;
            byte[] iv = new byte[16];
            StreamReadingUtils.readOrThrow(zipInputStream, iv);
            Cipher cipher = DecryptedEntryInputStream.createDecryptionCipher(param, contentKey, iv);
            byte[] buffer = new byte[4096];
            while ((readBytes = zipInputStream.read(buffer)) != -1) {
                if (readBytes <= 0) continue;
                cipher.update(buffer, 0, readBytes);
            }
            cipher.doFinal();
        }
        catch (AEADBadTagException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
            this.underlyingZipStream.closeEntry();
            if (this.closeUnderlying) {
                this.underlyingZipStream.close();
            }
        }
    }
}

