/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.metaeffekt.artifact.analysis.flow.ng.DecryptableKeyslot;
import com.metaeffekt.artifact.analysis.flow.ng.StreamReadingUtils;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.DecryptedEntryInputStream;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.ProviderParameters;
import com.metaeffekt.artifact.analysis.flow.ng.exception.DecryptionImpossibleException;
import com.metaeffekt.artifact.analysis.flow.ng.exception.SelfcheckFailedException;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForConsumer;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysStorage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.zip.ZipInputStream;
import javax.crypto.AEADBadTagException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedZipProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedZipProvider.class);
    private final ProviderParameters param;

    public EncryptedZipProvider(ProviderParameters param) {
        this.param = param;
    }

    private Key getDecryptedContentKey(InputStream keyslotsFileInputStream) throws IOException, InvalidCipherTextException {
        UserKeysForConsumer userKeys;
        try {
            userKeys = UserKeysStorage.readUserKeysForConsumer(this.param.getUserKeysFile(), this.param.getPassword(), true);
        }
        catch (SelfcheckFailedException e) {
            LOG.warn("Keyfile's selfcheck failed: possibly corrupt at [{}]", (Object)this.param.getUserKeysFile().getPath());
            userKeys = UserKeysStorage.readUserKeysForConsumer(this.param.getUserKeysFile(), this.param.getPassword(), false);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(keyslotsFileInputStream, 16384);
             InputStreamReader reader = new InputStreamReader((InputStream)bufferedInputStream, StandardCharsets.UTF_8);
             MappingIterator mappingIterator = new ObjectMapper().readerFor(DecryptableKeyslot.class).readValues((Reader)reader);){
            while (true) {
                if (mappingIterator.hasNext()) {
                    DecryptableKeyslot toCheck = (DecryptableKeyslot)mappingIterator.next();
                    if (!toCheck.checkHmac(userKeys)) continue;
                    byte[] contentKey = toCheck.getContentKeyUsing(userKeys);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(contentKey, this.param.getContentAlgorithmParam().getAlgorithm() + this.param.getContentAlgorithmParam().getMode());
                    return secretKeySpec;
                    continue;
                }
                break;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private Key processKeyslotsFile(ProviderParameters param) throws IOException, InvalidCipherTextException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream getEntryStream(String entryName) throws IOException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidCipherTextException {
        InputStream fileIn;
        Key contentKey = this.processKeyslotsFile(this.param);
        if (contentKey == null) {
            throw new DecryptionImpossibleException("No content key found for the specified user key.");
        }
        try {
            fileIn = Files.newInputStream(this.param.getEncryptedZipPackage().toPath(), StandardOpenOption.READ);
            Throwable throwable = null;
            try (ZipInputStream zipInputStream = new ZipInputStream(fileIn);){
                if (!StreamReadingUtils.skipToEntry(zipInputStream, entryName)) {
                    throw new FileNotFoundException("Zip package incompatible: could not find requested entry");
                }
                DecryptedEntryInputStream.ensureAuthenticated(zipInputStream, this.param.getContentAlgorithmParam(), contentKey);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileIn != null) {
                    if (throwable != null) {
                        try {
                            fileIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fileIn.close();
                    }
                }
            }
        }
        catch (AEADBadTagException e) {
            throw new RuntimeException(e);
        }
        fileIn = Files.newInputStream(this.param.getEncryptedZipPackage().toPath(), StandardOpenOption.READ);
        ZipInputStream zipInputStream = new ZipInputStream(fileIn);
        if (!StreamReadingUtils.skipToEntry(zipInputStream, entryName)) {
            throw new FileNotFoundException("Zip package incompatible: could not find requested entry");
        }
        return new ByteArrayInputStream(this.readEntryCompletely(entryName));
    }

    /*
     * Exception decompiling
     */
    public byte[] readEntryCompletely(String entryName) throws IOException, InvalidCipherTextException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

