/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.EncryptedZipProvider;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.ProviderParameters;
import com.metaeffekt.artifact.terms.model.LicenseTextEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class EncryptedTextCollectionReader {
    public Map<String, LicenseTextEntry> findLicenses(ProviderParameters param, Set<String> canonicalNameSet) {
        EncryptedZipProvider provider = new EncryptedZipProvider(param);
        HashMap<String, LicenseTextEntry> licenseTextEntries = new HashMap<String, LicenseTextEntry>();
        try (InputStream inputStream = provider.getEntryStream("ae-license-text-db.bin");
             GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
             InputStreamReader reader = new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8);){
            ObjectReader licenseTextEntryReader = new ObjectMapper().readerFor(LicenseTextEntry.class);
            MappingIterator it = licenseTextEntryReader.readValues((Reader)reader);
            try {
                while (it.hasNextValue()) {
                    Object o = it.nextValue();
                    LicenseTextEntry licenseTextEntry = (LicenseTextEntry)o;
                    if (!canonicalNameSet.contains(licenseTextEntry.getCanonicalName())) continue;
                    licenseTextEntries.put(licenseTextEntry.getCanonicalName(), licenseTextEntry);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unreadable json while parsing license text entries.", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An exception likely indicates misconfiguration (for example): dataset / scanner version mismatch, keys unauthorized for this artifact, key or data integrity error, invalid dataset or keyfile locations, (or other). Please contact {metaeffekt} for support.", e);
        }
        return licenseTextEntries;
    }
}

