/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.EncryptedEntryOutputStream;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.EncryptedZipSupplier;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.NormMetaSupplierParameters;
import com.metaeffekt.artifact.terms.model.LicenseTextEntry;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.ResolverUtils;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedTextCollectionSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedTextCollectionSupplier.class);

    public void process(NormMetaSupplierParameters param) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, NoSuchProviderException, InvalidKeyException {
        this.writeData(param);
    }

    protected void writeData(NormMetaSupplierParameters param) throws IOException, NoSuchProviderException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        try (EncryptedZipSupplier supplier = new EncryptedZipSupplier(param);
             EncryptedEntryOutputStream entryOutputStream = supplier.getEncryptedEntryStream("ae-license-text-db.bin");
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)entryOutputStream, 65536);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gzipOutputStream, StandardCharsets.UTF_8);
             SequenceWriter seq = new ObjectMapper().writerFor(LicenseTextEntry.class).withRootValueSeparator("\n").writeValues((Writer)writer);){
            NormalizationMetaData normMeta = param.getNormalizationMetaData();
            for (Map.Entry e : normMeta.getLicenseMetaDataMap().entrySet()) {
                String licenseText;
                TermsMetaData tmd = (TermsMetaData)e.getValue();
                File foundLicenseFile = ResolverUtils.findLicenseFor((TermsMetaData)tmd, (NormalizationMetaData)normMeta);
                if (foundLicenseFile == null) {
                    LOG.trace("No valid license file for license [{}].", (Object)tmd.getCanonicalName());
                    continue;
                }
                try (InputStream inputStream = Files.newInputStream(foundLicenseFile.toPath(), new OpenOption[0]);
                     InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    licenseText = IOUtils.toString((Reader)reader);
                }
                LicenseTextEntry licenseEntry = new LicenseTextEntry(tmd.getCanonicalName(), foundLicenseFile.getName(), licenseText);
                seq.write((Object)licenseEntry);
            }
        }
    }
}

