/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts;

import com.metaeffekt.artifact.analysis.flow.ng.ContentAlgorithmParam;
import com.metaeffekt.artifact.analysis.flow.ng.EncryptedArtifactProducerUtils;
import com.metaeffekt.artifact.analysis.flow.ng.KeypairGenerator;
import com.metaeffekt.artifact.analysis.flow.ng.TermMetaDataProducer;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts.EncryptedTextCollectionReader;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.licensetexts.EncryptedTextCollectionSupplier;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.GenericTmdProducerSpec;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.NormMetaSupplierParameters;
import com.metaeffekt.artifact.analysis.flow.ng.crypt.param.ProviderParameters;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForConsumer;
import com.metaeffekt.artifact.analysis.flow.ng.keyholder.UserKeysForSupplier;
import com.metaeffekt.artifact.terms.model.LicenseTextEntry;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextCollectionProducer {
    private static final Logger LOG = LoggerFactory.getLogger(TermMetaDataProducer.class);

    public static void produce(GenericTmdProducerSpec params) throws Exception {
        File tempDir = Files.createTempDirectory("textCollectGenerate-tempKeys-", new FileAttribute[0]).toFile();
        FileUtils.forceDeleteOnExit((File)tempDir);
        File dummyDecryptionKeysDir = new File(tempDir, "decryptionTestKeys");
        File allowedKeysWithDummy = new File(tempDir, "allowedKeys");
        File dummyZipOutputFile = new File(tempDir, "text-collection");
        SecureRandom random = new SecureRandom();
        File dummyKeyForUser = null;
        String temporaryPassword = null;
        if (params.isEnableImplicitTest()) {
            Pair<UserKeysForSupplier, UserKeysForConsumer> keypair = KeypairGenerator.createUserKeyPair(random);
            UserKeysForSupplier keysForSupplier = (UserKeysForSupplier)keypair.getLeft();
            UserKeysForConsumer keysForConsumer = (UserKeysForConsumer)keypair.getRight();
            File dummyKeyForPublisher = new File(allowedKeysWithDummy, "dummyKeyForPublisher.tmp.json");
            dummyKeyForUser = new File(dummyDecryptionKeysDir, "dummyKeyForUser.tmp.json");
            temporaryPassword = KeypairGenerator.generateUserKeysPassword(64);
            EncryptedArtifactProducerUtils.writeDummyKeys(dummyKeyForPublisher, dummyKeyForUser, keysForSupplier, keysForConsumer, temporaryPassword);
        }
        NormalizationMetaData normalizationMetaData = new NormalizationMetaData(params.getTermsMetaDataBaseDir());
        EncryptedArtifactProducerUtils.filterCustomerMetaData(normalizationMetaData);
        NormMetaSupplierParameters supplierParameters = new NormMetaSupplierParameters(new ContentAlgorithmParam(), normalizationMetaData, params.getAllowedUserKeysDir(), params.getLicenseTextFile(), params.getZipOutputFile());
        LOG.info("Beginning output of encrypted content.");
        EncryptedTextCollectionSupplier supplier = new EncryptedTextCollectionSupplier();
        supplier.process(supplierParameters);
        if (params.isEnableImplicitTest()) {
            LOG.info("Beginning test with dummy key.");
            NormMetaSupplierParameters dummySupplierParam = new NormMetaSupplierParameters(new ContentAlgorithmParam(), normalizationMetaData, allowedKeysWithDummy, params.getLicenseTextFile(), dummyZipOutputFile);
            EncryptedTextCollectionSupplier dummySupplier = new EncryptedTextCollectionSupplier();
            dummySupplier.process(dummySupplierParam);
            ProviderParameters providerParameters = new ProviderParameters(new ContentAlgorithmParam(), temporaryPassword, dummyKeyForUser, dummyZipOutputFile);
            List<String> canonicalNames = Collections.singletonList("Apache License 2.0");
            EncryptedTextCollectionReader provider = new EncryptedTextCollectionReader();
            Map<String, LicenseTextEntry> queryResult = provider.findLicenses(providerParameters, Collections.singleton("Apache License 2.0"));
            EncryptedArtifactProducerUtils.assertEquals(queryResult.get("Apache License 2.0").getCanonicalName(), "Apache License 2.0");
            EncryptedArtifactProducerUtils.assertEquals(1, queryResult.size());
            EncryptedArtifactProducerUtils.assertEquals(true, queryResult.keySet().containsAll(canonicalNames));
            for (String name : canonicalNames) {
                if (queryResult.get(name) == null) {
                    throw new RuntimeException("Self-test failed: text collection didn't contain " + name + ".");
                }
                EncryptedArtifactProducerUtils.assertEquals(name, queryResult.get(name).getCanonicalName());
            }
            LOG.info("Collection query result: " + queryResult);
        } else {
            LOG.warn("Implicit output testing is disabled!");
        }
    }
}

