/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.notice;

import com.metaeffekt.artifact.analysis.flow.InventoryResult;
import com.metaeffekt.artifact.analysis.flow.notice.GenerateNoticeParameterFlowParam;
import com.metaeffekt.artifact.analysis.flow.notice.NoticeParameterBuilderAnalysis;
import com.metaeffekt.artifact.analysis.flow.notice.NoticeParameterBuilderInventory;
import com.metaeffekt.artifact.analysis.flow.notice.NoticeParameterPostProcessing;
import com.metaeffekt.resource.InventoryResource;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateNoticeParameterFlow {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateNoticeParameterFlow.class);

    public InventoryResult process(GenerateNoticeParameterFlowParam param) {
        LOG.info("Deriving NoticeParameters from scan results...");
        Inventory inventory = param.getInventoryResource().getInventory();
        try {
            NoticeParameterBuilderAnalysis noticeParameterBuilderAnalysis = new NoticeParameterBuilderAnalysis(param.getNormalizationMetaData());
            noticeParameterBuilderAnalysis.enrichInventoryWithNoticeParameter(inventory);
            NoticeParameterBuilderInventory noticeParameterBuilderInventory = new NoticeParameterBuilderInventory(param.getNormalizationMetaData());
            noticeParameterBuilderInventory.enrichInventoryWithNoticeParameter(inventory);
            NoticeParameterPostProcessing noticeParameterPostProcessing = new NoticeParameterPostProcessing();
            noticeParameterPostProcessing.postProcessNoticeParameter(inventory);
        }
        catch (Exception e) {
            LOG.warn("Cannot generate notice parameter.", (Throwable)e);
        }
        LOG.info("Deriving NoticeParameters from scan results completed.");
        return new InventoryResult(InventoryResource.fromInventory((Inventory)inventory));
    }
}

