/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.notice;

import com.metaeffekt.artifact.analysis.flow.notice.NoticeParameterPostProcessing;
import com.metaeffekt.artifact.analysis.metascan.MergedScanResult;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.workbench.InventoryTransformer;
import com.metaeffekt.artifact.terms.model.MergedSegmentResult;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import com.metaeffekt.artifact.terms.model.Variables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.common.notice.model.UnassignedInformation;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeParameterBuilderAnalysis {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final String KEY_ANALYSIS_PATH = "Analysis Path";
    private static final String KEY_SOURCE_ANALYSIS_PATH = "Source Artifact - Path";
    private static final String KEY_SOURCE_ARCHIVE_PATH = "Source Archive - Path";
    private final NormalizationMetaData normalizationMetaData;
    private final InventoryTransformer transformer;

    public NoticeParameterBuilderAnalysis(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
        this.transformer = new InventoryTransformer(normalizationMetaData);
    }

    public Inventory enrichInventoryWithNoticeParameter(Inventory inventory) throws IOException {
        int i = 1;
        for (Artifact artifact : inventory.getArtifacts()) {
            this.LOG.debug("Building notice parameter for {} ({}/{})", new Object[]{artifact.deriveQualifier(), i++, inventory.getArtifacts().size()});
            String noticeParam = this.buildNoticeParameter(artifact);
            artifact.set("Derived Notice Parameter", noticeParam);
        }
        return inventory;
    }

    public String buildNoticeParameter(Artifact artifact) throws IOException {
        List<ComponentSet> components;
        MergedScanResult mergedScanResult = new MergedScanResult();
        mergedScanResult.mergeResults(artifact, NoticeParameterBuilderAnalysis.getAnalysisTargetFile(artifact, "Binary Artifact - Analysis Path"));
        mergedScanResult.mergeResults(artifact, NoticeParameterBuilderAnalysis.getAnalysisTargetFile(artifact, "Source Artifact - Analysis Path"));
        mergedScanResult.mergeResults(artifact, NoticeParameterBuilderAnalysis.getAnalysisTargetFile(artifact, "Source Archive - Analysis Path"));
        mergedScanResult.mergeResults(artifact, NoticeParameterBuilderAnalysis.getAnalysisTargetFile(artifact, "Descriptor - Analysis Path"));
        mergedScanResult.mergeResults(artifact, NoticeParameterBuilderAnalysis.getAnalysisTargetFile(artifact, KEY_ANALYSIS_PATH));
        List mergedScanResultList = mergedScanResult.getMergedScanResult();
        if (!mergedScanResultList.isEmpty() && !(components = this.getComponentList(mergedScanResultList)).isEmpty()) {
            NoticeParameters noticeParameters = this.writeNoticeParameter(components);
            NoticeParameterPostProcessing postProcessing = new NoticeParameterPostProcessing();
            postProcessing.postProcessNoticeParameter(noticeParameters);
            return noticeParameters.toYamlString();
        }
        return null;
    }

    private static File getAnalysisTargetFile(Artifact artifact, String keyAnalysisPath) {
        String analysisDir = artifact.get(keyAnalysisPath);
        if (analysisDir == null) {
            return null;
        }
        File analysisFile = new File(analysisDir);
        File targetFolder = new File(analysisDir + "-analysis");
        if (!targetFolder.exists()) {
            return null;
        }
        return analysisFile;
    }

    private List<ComponentSet> getComponentList(List<MergedSegmentResult> scanResult) throws IOException {
        ArrayList<ComponentSet> components = new ArrayList<ComponentSet>();
        for (MergedSegmentResult segmentResult : scanResult) {
            ComponentSet componentSet = new ComponentSet();
            List<String> resolvedLicenses = this.transformer.transformLicenses(segmentResult.getResolvedLicenses());
            List copyrights = segmentResult.getCopyrights();
            if (resolvedLicenses.isEmpty()) {
                if (segmentResult.getCopyrights().isEmpty()) continue;
                componentSet.addUnassignedCopyright(segmentResult.getCopyrights());
                components.add(componentSet);
                continue;
            }
            InventoryUtils.initialize((NormalizationMetaData)this.normalizationMetaData);
            InventoryUtils.removeMarkers(resolvedLicenses, (NormalizationMetaData)this.normalizationMetaData);
            if (resolvedLicenses.isEmpty()) continue;
            componentSet.setLicenses(resolvedLicenses);
            if (!segmentResult.getVariables().isEmpty()) {
                componentSet.addVariables(segmentResult.getVariables());
            }
            if (resolvedLicenses.size() > 1 && this.splitRequired(componentSet, this.normalizationMetaData)) {
                componentSet.setSimple(true);
            }
            boolean existing = false;
            for (ComponentSet component : components) {
                if (!component.getLicenses().equals(resolvedLicenses) || !segmentResult.getVariables().isEmpty() && segmentResult.getVariables().equals(component.getVariables())) continue;
                component.addCopyrights(copyrights);
                existing = true;
                break;
            }
            if (existing) continue;
            componentSet.setCopyrights(copyrights);
            components.add(componentSet);
        }
        for (int componentCount = 0; componentCount < components.size(); ++componentCount) {
            ArrayList<Object> variablesList;
            ComponentSet componentSet;
            TermsMetaData termsMetaData;
            int j;
            ComponentSet component = (ComponentSet)components.get(componentCount);
            if (!component.isSimple()) continue;
            List<String> licenses = component.getLicenses();
            if (licenses != null && !licenses.isEmpty() && component.getCopyrights().isEmpty()) {
                ArrayList<ComponentSet> newComponents = new ArrayList<ComponentSet>();
                for (j = 0; j < licenses.size(); ++j) {
                    String license = licenses.get(j);
                    termsMetaData = this.normalizationMetaData.getTermsMetaData(license);
                    if (termsMetaData == null || !termsMetaData.hasVariables() && (termsMetaData.getRequiresCopyright() == null || !termsMetaData.getRequiresCopyright().booleanValue())) continue;
                    componentSet = new ComponentSet();
                    componentSet.setLicenses(new ArrayList<String>(Collections.singleton(license)));
                    component.getLicenses().remove(license);
                    if (termsMetaData.hasVariables()) {
                        for (Variables variable : component.getVariables()) {
                            if (!variable.getLicense().equals(license)) continue;
                            variablesList = new ArrayList();
                            variablesList.add(variable);
                            componentSet.addVariables(variablesList);
                            component.getVariables().remove(variable);
                            break;
                        }
                    }
                    newComponents.add(componentSet);
                }
                if (!licenses.isEmpty()) {
                    newComponents.add(component);
                }
                components.remove(component);
                components.addAll(newComponents);
                continue;
            }
            int variableCount = 0;
            for (j = 0; j < licenses.size(); ++j) {
                String license = licenses.get(j);
                termsMetaData = this.normalizationMetaData.getTermsMetaData(license);
                if (termsMetaData == null || !termsMetaData.hasVariables() || ++variableCount <= 1) continue;
                componentSet = new ComponentSet();
                componentSet.setSimple(true);
                componentSet.setLicenses(Collections.singletonList(license));
                component.getLicenses().remove(license);
                for (Variables variable : component.getVariables()) {
                    if (!variable.getLicense().equals(license)) continue;
                    variablesList = new ArrayList<Variables>();
                    variablesList.add(variable);
                    componentSet.addVariables(variablesList);
                    component.getVariables().remove(variable);
                    break;
                }
                componentSet.setCopyrights(component.getCopyrights());
                components.add(componentSet);
            }
        }
        return components;
    }

    public NoticeParameters writeNoticeParameter(List<ComponentSet> components) {
        NoticeParameters noticeParameters = new NoticeParameters();
        boolean mainComponent = false;
        ArrayList<ComponentDefinition> subcomponents = new ArrayList<ComponentDefinition>();
        UnassignedInformation unassignedInformation = new UnassignedInformation();
        boolean requiresCopyright = false;
        block0: for (ComponentSet componentSet : components) {
            if (!componentSet.getUnassignedCopyrights().isEmpty()) {
                unassignedInformation.addCopyrights(componentSet.getUnassignedCopyrights());
                continue;
            }
            ComponentDefinition componentDefinition = new ComponentDefinition();
            if (!componentSet.isSimple()) {
                String license = componentSet.getLicenses().get(0);
                TermsMetaData termsMetaData = this.normalizationMetaData.getTermsMetaData(license);
                if (termsMetaData != null) {
                    if (termsMetaData.getRequiresCopyright() != null && termsMetaData.getRequiresCopyright().booleanValue() && componentSet.getCopyrights() != null) {
                        componentDefinition.setCopyrights(componentSet.getCopyrights());
                    }
                    if (termsMetaData.getRequiresCopyright() == null && !componentSet.getCopyrights().isEmpty()) {
                        componentDefinition.setCopyrights(componentSet.getCopyrights());
                    }
                }
                componentDefinition.setAssociatedLicenses(componentSet.getLicenses());
                if (!componentSet.getVariables().isEmpty()) {
                    Map values = componentSet.getVariables().get(0).getValues();
                    componentDefinition.setVariables(values);
                }
            } else {
                componentDefinition.setComponentStatus("Segmentation Issue in this component. Split into subcomponents required.");
                componentDefinition.setAssociatedLicenses(componentSet.getLicenses());
                if (componentDefinition.getCopyrights() != null) {
                    componentDefinition.setCopyrights(componentSet.getCopyrights());
                }
                if (!componentSet.getVariables().isEmpty()) {
                    Map values = componentSet.getVariables().get(0).getValues();
                    componentDefinition.setVariables(values);
                }
            }
            if (!mainComponent) {
                noticeParameters.setComponent(componentDefinition);
                mainComponent = true;
            } else {
                subcomponents.add(componentDefinition);
            }
            if (requiresCopyright) continue;
            for (String license : componentSet.getLicenses()) {
                TermsMetaData termsMetaData = this.normalizationMetaData.getTermsMetaData(license);
                if (termsMetaData == null || termsMetaData.getRequiresCopyright() == null || !termsMetaData.getRequiresCopyright().booleanValue()) continue;
                requiresCopyright = true;
                continue block0;
            }
        }
        if (unassignedInformation.getCopyrights() != null && !requiresCopyright) {
            noticeParameters.setUnassignedInformation(unassignedInformation);
        }
        if (!subcomponents.isEmpty()) {
            noticeParameters.setSubcomponents(subcomponents);
        }
        return noticeParameters;
    }

    private boolean splitRequired(ComponentSet component, NormalizationMetaData normalizationMetaData) {
        int variableCount = 0;
        boolean requiresCopyright = false;
        for (String license : component.getLicenses()) {
            TermsMetaData termsMetaData = normalizationMetaData.getTermsMetaData(license);
            if (termsMetaData == null) continue;
            if (termsMetaData.hasVariables()) {
                ++variableCount;
            }
            if (termsMetaData.getRequiresCopyright() == null) {
                requiresCopyright = true;
                continue;
            }
            if (!termsMetaData.getRequiresCopyright().booleanValue()) continue;
            requiresCopyright = true;
        }
        return variableCount > 1 || requiresCopyright;
    }

    private class ComponentSet {
        protected final List<String> licenses = new ArrayList<String>();
        protected final List<String> copyrights = new ArrayList<String>();
        protected final List<Variables> variables = new ArrayList<Variables>();
        protected boolean simple;
        protected final List<String> unassignedCopyrights = new ArrayList<String>();

        private ComponentSet() {
        }

        public void setLicenses(List<String> licenses) {
            this.copyrights.clear();
            this.licenses.addAll(licenses);
        }

        public void setCopyrights(List<String> copyrights) {
            this.copyrights.clear();
            this.copyrights.addAll(copyrights);
        }

        public void addUnassignedCopyright(List<String> unassignedCopyrights) {
            this.unassignedCopyrights.addAll(unassignedCopyrights);
        }

        public void addCopyrights(List<String> copyrights) {
            this.copyrights.addAll(copyrights);
        }

        public void addVariables(List<Variables> variables) {
            this.variables.addAll(variables);
        }

        public List<String> getLicenses() {
            return this.licenses;
        }

        public List<String> getCopyrights() {
            return this.copyrights;
        }

        public List<Variables> getVariables() {
            return this.variables;
        }

        public boolean isSimple() {
            return this.simple;
        }

        public List<String> getUnassignedCopyrights() {
            return this.unassignedCopyrights;
        }

        public void setSimple(boolean simple) {
            this.simple = simple;
        }
    }
}

