/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.flow.notice;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.core.inventory.InventoryUtils;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeParameterBuilderInventory {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeParameterBuilderInventory.class);
    private final NormalizationMetaData normalizationMetaData;

    public NoticeParameterBuilderInventory(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
    }

    public Inventory enrichInventoryWithNoticeParameter(Inventory inventory) throws IOException {
        block0: for (Artifact artifact : inventory.getArtifacts()) {
            ParameterSet[] parameterSets;
            if (StringUtils.hasText((String)artifact.get("Derived Notice Parameter"))) continue;
            ParameterSet derivedObservedParameterSet = new ParameterSet().withLicenseAndCopyrights(artifact.get("Derived Licenses"), artifact.get("Extracted Copyrights (ScanCode)"));
            for (ParameterSet parameterSet : parameterSets = new ParameterSet[]{derivedObservedParameterSet, this.getDerivedBinaryParameterSet(artifact, "Binary Artifact"), this.getDerivedBinaryParameterSet(artifact, "Source Artifact"), this.getDerivedBinaryParameterSet(artifact, "Descriptor"), this.getDerivedBinaryParameterSet(artifact, "Source Archive")}) {
                String noticeParameter;
                if (!this.isApplicable(parameterSet) || (noticeParameter = this.buildNoticeParameter(parameterSet)) == null) continue;
                artifact.set("Derived Notice Parameter", noticeParameter);
                continue block0;
            }
        }
        return inventory;
    }

    private ParameterSet getDerivedBinaryParameterSet(Artifact artifact, String prefix) {
        return new ParameterSet().withLicenseAndCopyrights(artifact.get(prefix + " - Derived License"), artifact.get(prefix + " - Extracted Copyrights (ScanCode)"));
    }

    private String buildNoticeParameter(ParameterSet parameterSet) {
        NoticeParameters noticeParameter = new NoticeParameters();
        ComponentDefinition component = new ComponentDefinition();
        String associatedLicense = parameterSet.license;
        String effectiveLicenses = com.metaeffekt.artifact.analysis.utils.InventoryUtils.deriveEffectiveLicenses((String)associatedLicense);
        TermsMetaData tmd = this.getEffectiveTermsMetaDataNonNull(effectiveLicenses);
        if (tmd.getRequiresCopyright() != null && tmd.getRequiresCopyright().booleanValue()) {
            if (StringUtils.isEmpty((String)parameterSet.copyrights)) {
                return null;
            }
            String scanCodeCopyrights = parameterSet.copyrights;
            List<String> copyrights = Arrays.asList(scanCodeCopyrights.split("\\|\n"));
            component.setCopyrights(copyrights);
        }
        component.setAssociatedLicenses(InventoryUtils.tokenizeLicense((String)parameterSet.license, (boolean)true, (boolean)true));
        if (!effectiveLicenses.equals(associatedLicense)) {
            component.setEffectiveLicenses(InventoryUtils.tokenizeLicense((String)effectiveLicenses, (boolean)true, (boolean)true));
        }
        noticeParameter.setComponent(component);
        return noticeParameter.toYamlString();
    }

    private boolean isApplicable(ParameterSet artifact) {
        List licenses = InventoryUtils.tokenizeLicense((String)artifact.license, (boolean)false, (boolean)false);
        return licenses.size() == 1;
    }

    public TermsMetaData getEffectiveTermsMetaDataNonNull(String license) {
        TermsMetaData termsMetaData = this.normalizationMetaData.findTermsMetaData(license);
        if (termsMetaData == null) {
            return NoticeParameterBuilderInventory.createDefaultTermsMetaData(license);
        }
        return termsMetaData;
    }

    public static TermsMetaData createDefaultTermsMetaData(String name) {
        TermsMetaData tmd = new TermsMetaData();
        tmd.setCanonicalName(name);
        tmd.setRequiresNote(true);
        tmd.setRequiresCopyright(Boolean.valueOf(false));
        tmd.setTemporaryLMD(true);
        return tmd;
    }

    private static class ParameterSet {
        protected String license;
        protected String copyrights;

        private ParameterSet() {
        }

        protected ParameterSet withLicenseAndCopyrights(String license, String copyrights) {
            this.license = license;
            this.copyrights = copyrights;
            if (copyrights != null && copyrights.startsWith("[")) {
                this.copyrights = null;
            }
            return this;
        }

        public String toString() {
            return "NoticeParameterBuilderInventory.ParameterSet(license=" + this.license + ", copyrights=" + this.copyrights + ")";
        }
    }
}

