/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.workbench.InventoryTransformer;
import com.metaeffekt.artifact.terms.model.LicenseTextEntry;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.metaeffekt.core.inventory.InventoryUtils;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.LicenseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseAggregationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseAggregationUtils.class);

    /*
     * Unable to fully structure code
     */
    public static List<String> copyLicenses(Inventory inventory, File targetProjectDir, NormalizationMetaData normalizationMetaData, LicenseTextProvider licenseTextProvider, boolean failOnError) {
        filterForOpenCode = false;
        targetProjectLicencesDir = new File(targetProjectDir, "licenses");
        allLicenses = new HashSet<String>();
        for (Artifact artifact : inventory.getArtifacts()) {
            associatedLicense = artifact.getLicense();
            effectiveLicense = inventory.getEffectiveLicense(artifact);
            allLicenses.addAll(InventoryUtils.tokenizeLicense((String)associatedLicense, (boolean)false, (boolean)true));
            allLicenses.addAll(InventoryUtils.tokenizeLicense((String)effectiveLicense, (boolean)false, (boolean)false));
        }
        for (LicenseData licenseData : inventory.getLicenseData()) {
            allLicenses.add(licenseData.get(LicenseData.Attribute.CANONICAL_NAME));
        }
        collectedCanonicalNames = new ArrayList<String>();
        inventoryTransformer = new InventoryTransformer(normalizationMetaData);
        licenseToNormalizedMetaDataMap = new HashMap<String, TermsMetaData>();
        for (String licenseExpression : allLicenses) {
            for (String license : com.metaeffekt.artifact.analysis.utils.InventoryUtils.tokenizeLicense((String)licenseExpression, (boolean)false, (boolean)false)) {
                normalizedLicense = license.trim();
                termsMetaData = normalizationMetaData.getTermsMetaData(normalizedLicense = inventoryTransformer.getUpdatedCanonicalName(normalizedLicense));
                if (termsMetaData != null && (namedEquivalence = termsMetaData.getNamedEquivalence()) != null) {
                    termsMetaData = normalizationMetaData.getTermsMetaData(namedEquivalence);
                    normalizedLicense = namedEquivalence;
                }
                licenseToNormalizedMetaDataMap.put(normalizedLicense, termsMetaData);
                licenseToNormalizedMetaDataMap.putIfAbsent(license, termsMetaData);
            }
        }
        licenseTextMap = licenseTextProvider.resolve(licenseToNormalizedMetaDataMap.keySet());
        for (Map.Entry<K, V> licenseMapEntry : licenseToNormalizedMetaDataMap.entrySet()) {
            licenseExpression = (String)licenseMapEntry.getKey();
            for (String license : com.metaeffekt.artifact.analysis.utils.InventoryUtils.tokenizeLicense((String)licenseExpression, (boolean)false, (boolean)false)) {
                targetDir = new File(targetProjectLicencesDir, inventory.getLicenseFolder(license));
                termsMetaData = (TermsMetaData)licenseToNormalizedMetaDataMap.get(license);
                if (termsMetaData == null) {
                    message = "No license metadata available, cannot copy license. Normalized license: [" + licenseExpression + "]; license: [" + license + "]";
                    if (failOnError) {
                        throw new IllegalStateException(message);
                    }
                    LicenseAggregationUtils.LOG.warn(message);
                    continue;
                }
                licenseFile = (LicenseTextEntry)licenseTextMap.get(licenseExpression);
                if (licenseFile == null && (termsMetaData.isExpression() || termsMetaData.isMarker() || termsMetaData.isUnspecific())) continue;
                if (licenseFile != null) {
                    try {
                        targetFile = new File(targetDir, new File(licenseFile.getFilename()).getName());
                        FileUtils.write((File)targetFile, (CharSequence)licenseFile.getLicenseText(), (String)"UTF-8");
                    }
                    catch (IOException e) {
                        if (!failOnError) ** GOTO lbl60
                        throw new IllegalStateException("Cannot copy license files.", e);
                    }
                } else if (!termsMetaData.isExpression()) {
                    message = "No license file available for [" + license + "]";
                    if (failOnError) {
                        throw new IllegalStateException(message);
                    }
                    System.out.println(message);
                    continue;
                }
lbl60:
                // 4 sources

                if ((copiedFiles = targetDir.exists() != false ? (long)FileUtils.scanDirectoryForFiles((File)targetDir, (boolean)true, (String[])new String[]{"*.*"}).length : 0L) != 0L || !failOnError) continue;
                throw new IllegalStateException("No license file provided for: " + license);
            }
        }
        return collectedCanonicalNames;
    }

    public static void fillLicenseMetaData(InventoryResource inventoryResource, NormalizationMetaData normalizationMetaData) {
        for (LicenseData licenseData : inventoryResource.getInventory().getLicenseData()) {
            String canonicalName = licenseData.get(LicenseData.Attribute.CANONICAL_NAME);
            TermsMetaData termsMetaData = normalizationMetaData.getTermsMetaData(canonicalName);
            if (termsMetaData == null) {
                termsMetaData = normalizationMetaData.findUsingCanonicalNameInHistory(canonicalName);
            }
            if (termsMetaData == null) continue;
            com.metaeffekt.artifact.analysis.utils.InventoryUtils.transferTmdAttributesToLicenseData((LicenseData)licenseData, (TermsMetaData)termsMetaData);
            if (canonicalName.equals(termsMetaData.getCanonicalName())) continue;
            licenseData.set(LicenseData.Attribute.CANONICAL_NAME, termsMetaData.getCanonicalName());
            licenseData.set("Original Canonical Name", canonicalName);
        }
    }
}

