/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageLicenseTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(PackageLicenseTransformer.class);
    public static final String PACKAGE_SPECIFIED_LICENSE = "Package Specified License";
    public static final String PACKAGE_SPECIFIED_LICENSE_MAPPED = "Package Specified License (mapped)";
    public static final String PACKAGE_SPECIFIED_LICENSE_UNMAPPED = "Package Specified License (unknown)";
    public static final String COMPONENT_SPECIFIED_LICENSE = "Component Specified License";
    public static final String COMPONENT_SPECIFIED_LICENSE_MAPPED = "Component Specified License (mapped)";
    public static final String COMPONENT_SPECIFIED_LICENSE_UNMAPPED = "Component Specified License (unknown)";
    private Set<String> unmapped = new HashSet<String>();

    public static String joinDisjunctiveLicenses(Collection<String> licenses) {
        return licenses.stream().collect(Collectors.joining(" + "));
    }

    public Inventory transformPackageLicenses(Inventory inventory) {
        if (inventory != null) {
            this.transform(inventory);
        }
        return inventory;
    }

    private Inventory transform(Inventory inventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            this.transformPackageLicenses(artifact);
        }
        return inventory;
    }

    public void transformPackageLicenses(Artifact artifact) {
        this.transform(artifact, PACKAGE_SPECIFIED_LICENSE, PACKAGE_SPECIFIED_LICENSE_MAPPED, PACKAGE_SPECIFIED_LICENSE_UNMAPPED);
    }

    public void transformComponentLicenses(Artifact artifact) {
        this.transform(artifact, COMPONENT_SPECIFIED_LICENSE, COMPONENT_SPECIFIED_LICENSE_MAPPED, COMPONENT_SPECIFIED_LICENSE_UNMAPPED);
    }

    private void transform(Artifact artifact, String attributeKey, String attributeKeyMapped, String attributeKeyUnmapped) {
        ArrayList<String> artifactUnmappedLicenses = new ArrayList<String>();
        String specifiedPackageLicenses = artifact.get(attributeKey);
        if (specifiedPackageLicenses == null) {
            specifiedPackageLicenses = artifact.get("Package Specified Licenses");
        }
        if (specifiedPackageLicenses != null) {
            String preprocessLicenseExpression = this.preprocessLicenseExpression(specifiedPackageLicenses);
            String licenseExpression = this.transformLicenseExpression(preprocessLicenseExpression, artifactUnmappedLicenses);
            licenseExpression = this.postprocessLicenseExpression(licenseExpression);
            this.isValid(licenseExpression, artifact);
            artifact.set(attributeKeyMapped, licenseExpression);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("%-60s --> (%s)", specifiedPackageLicenses, preprocessLicenseExpression));
                LOG.debug(String.format("%-60s --> %s", "(" + preprocessLicenseExpression + ")", licenseExpression));
            }
            if (!artifactUnmappedLicenses.isEmpty()) {
                String unmappedLicense = InventoryUtils.joinLicenses(artifactUnmappedLicenses);
                artifact.set(attributeKeyUnmapped, unmappedLicense);
                LOG.info(String.format("%-60s --> (%s)", specifiedPackageLicenses, preprocessLicenseExpression));
                LOG.info(String.format("%-60s --> %s", "(" + preprocessLicenseExpression + ")", licenseExpression));
                LOG.warn(String.format("%64s %s", "unmapped licenses:", unmappedLicense));
                this.unmapped.addAll(artifactUnmappedLicenses);
            }
        }
    }

    private String postprocessLicenseExpression(String license) {
        license = license.replace("XX;;XX", ",");
        license = license.replace("ANY + ", "");
        return license;
    }

    public String preprocessLicenseExpression(String specifiedPackageLicenses) {
        if (StringUtils.isEmpty((String)specifiedPackageLicenses)) {
            return specifiedPackageLicenses;
        }
        if ("LGPL-3.0-or-later, or, GPL-2.0-or-later, or, (LGPL-3.0-or-later, GPL-2.0-or-later)".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "LGPL-3.0-or-later, or, GPL-2.0-or-later";
        }
        if ("BSD-3-Clause GPL-2.0-or-later".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "BSD-3-Clause, GPL-2.0-or-later";
        }
        if ("(IBM and GPLv2+) or (EPL-2.0 and GPLv2+)".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "IBM Public License 1.0 + Eclipse Public License 2.0, GPLv2+";
        }
        if ("BSD or Apache License, Version 2.0".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "BSD + Apache-2.0";
        }
        if ("GPL-2.0-or-later LGPL-2.1-or-later".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "GPL-2.0-or-later, LGPL-2.1-or-later";
        }
        if ("MIT BSD GPL2+".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MIT, BSD, GPL2+";
        }
        if ("MPL-2.0 GPL-2.0-or-later".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MPL-2.0, GPL-2.0-or-later";
        }
        if ("LGPLv2.1/MIT".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "LGPLv2.1, MIT";
        }
        if ("[\"AFLv2.1\",\"BSD\"]".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "AFLv2.1, BSD";
        }
        if ("GPL-3.0+, with, exception".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "GNU General Public License 3.0 (or any later version, with exceptions)";
        }
        if ("ISC, AND, (, BSD-3-Clause, OR, MIT, )".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "ISC, BSD-3-Clause or MIT";
        }
        if ("[\"AFLv2.1\",\"BSD\"]".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "AFLv2.1, BSD";
        }
        if ("Public, Domain".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "Public Domain";
        }
        if ("GPL-2.0-only, WITH, Classpath-exception-2.0".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "GNU General Public License 2.0 (with classpath exception)";
        }
        if ("(IBM and GPLv2+) or (EPL-2.0 and GPLv2+)".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "IBM or EPL-2.0, GPLv2+";
        }
        if ("2-clause, BSD-like, license".equals(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "BSD 2-Clause License, BSD alike";
        }
        if ("GPLv2+ BSD LGPL-2.1+ LGPL-2.0+".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "GPLv2+ and BSD and LGPL-2.1+ and LGPL-2.0+";
        }
        if ("GPLv2+, LGPLv2+, MIT".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "GPLv2+ and LGPLv2+ and MIT";
        }
        if ("GPLv3+, GFDL".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "GPLv3+ and GFDL";
        }
        if ("LGPLv2+ Public Domain".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "LGPLv2+ and Public Domain";
        }
        if ("(MIT and BSD and BSD with advertising) and GPLv2".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MIT, BSD, BSD with advertising, GPLv2";
        }
        if ("(MIT or AFL), (MIT or GPLv2)".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MIT or AFL, MIT or GPLv2";
        }
        if ("(MIT or AFL), (MIT or GPLv2)".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MIT or AFL, MIT or GPLv2";
        }
        if ("(MIT and BSD and BSD with advertising) and GPLv2".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MIT, BSD, BSD with advertising, GPLv2";
        }
        if ("(MIT or AFL) and (MIT or GPLv2)".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MIT or AFL, MIT or GPLv2";
        }
        if ("(MIT or AFL) and (MIT or GPLv2)".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "MIT or AFL, MIT or GPLv2";
        }
        if ("BSD-3-Clause, AND, BSD-2-Clause, AND, ISC, AND, Beerware, AND, Public, Domain".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "BSD 3-Clause, BSD-2-Clause, ISC, Beerware, Public Domain";
        }
        if ("Public, Domain".equalsIgnoreCase(specifiedPackageLicenses)) {
            specifiedPackageLicenses = "Public Domain";
        }
        specifiedPackageLicenses = specifiedPackageLicenses.replace("Redistributable, no modification permitted", "Redistributable (no modification permitted)");
        specifiedPackageLicenses = specifiedPackageLicenses.replace("or later", "XX+XX");
        specifiedPackageLicenses = specifiedPackageLicenses.replace("or any later", "XX++XX");
        specifiedPackageLicenses = this.removeOutterBrackets(specifiedPackageLicenses);
        specifiedPackageLicenses = specifiedPackageLicenses.replace("Notice and License", "NoticeXXANDXXLicense");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(", OR, ", " + ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(" OR ", " + ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(", AND, ", ", ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(" AND ", ", ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(", or, ", " + ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(" or ", " + ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(", and, ", ", ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace(" and ", ", ");
        specifiedPackageLicenses = specifiedPackageLicenses.replace("XX+XX", "or later");
        specifiedPackageLicenses = specifiedPackageLicenses.replace("XX++XX", "or any later");
        if ((specifiedPackageLicenses = specifiedPackageLicenses.replace("XXANDXX", " and ")).endsWith(", AND")) {
            specifiedPackageLicenses = specifiedPackageLicenses.substring(0, 5);
        }
        return specifiedPackageLicenses;
    }

    public String transformLicenseExpression(String license, List<String> artifactUnmappedLicenses) {
        List rawLicenses = InventoryUtils.tokenizeLicense((String)license, (boolean)false, (boolean)true);
        List<String> mappedLicenses = this.mapLicenses(rawLicenses, artifactUnmappedLicenses);
        return InventoryUtils.joinLicenses(mappedLicenses);
    }

    public void dumpUnmapped() {
        this.unmapped.forEach(l -> LOG.warn("Unmapped license {}", l));
    }

    public List<String> mapLicenses(Collection<String> licenses) {
        if (licenses == null) {
            return null;
        }
        return this.mapLicenses(licenses, new HashSet<String>());
    }

    private List<String> mapLicenses(Collection<String> licenses, Collection<String> unmapped) {
        ArrayList<String> mappedLicenses = new ArrayList<String>();
        for (String license : licenses) {
            license = license.trim();
            license = this.removeOutterBrackets(license);
            List licenseParts = InventoryUtils.tokenizeLicense((String)license, (boolean)false, (boolean)true);
            for (String licensePart : licenseParts) {
                String[] atomicLicenses = licensePart.split(" \\+ ");
                ArrayList<String> multiLicense = new ArrayList<String>();
                for (String atomicLicense : atomicLicenses) {
                    multiLicense.add(this.applyMapping(atomicLicense, unmapped));
                }
                mappedLicenses.add(PackageLicenseTransformer.joinDisjunctiveLicenses(multiLicense));
            }
        }
        return mappedLicenses;
    }

    private String removeOutterBrackets(String license) {
        if (StringUtils.isEmpty((String)license)) {
            return license;
        }
        if (license.startsWith("(") && license.endsWith(")") && org.springframework.util.StringUtils.countOccurrencesOf((String)license, (String)"(") == 1 && org.springframework.util.StringUtils.countOccurrencesOf((String)license, (String)")") == 1) {
            license = license.substring(1, license.length() - 1);
        }
        return license;
    }

    private String applyMapping(String license, Collection<String> unmapped) {
        NormalizationMetaData normalizationMetaData = InventoryUtils.getNormalizationMetaData();
        TermsMetaData tmd = normalizationMetaData.getTermsMetaData(license);
        if (tmd != null) {
            return tmd.getCanonicalName();
        }
        TermsMetaData tmdMapping = normalizationMetaData.findTermsMetaData(license);
        if (tmdMapping != null) {
            return tmdMapping.getCanonicalName();
        }
        TermsMetaData tmdMappingAlternative = this.findMyShortNameSPDXorOtherId(license);
        if (tmdMappingAlternative != null) {
            return tmdMappingAlternative.getCanonicalName();
        }
        TermsMetaData tmdShortNameMapped = normalizationMetaData.findByShortName(license);
        if (tmdShortNameMapped != null) {
            return tmdShortNameMapped.getCanonicalName();
        }
        unmapped.add(this.postprocessLicenseExpression(license));
        return license;
    }

    private TermsMetaData findMyShortNameSPDXorOtherId(String name) {
        TermsMetaData resolveUnspecific;
        NormalizationMetaData normalizationMetaData = InventoryUtils.getNormalizationMetaData();
        String shortName = name.replace(" ", "-");
        for (TermsMetaData termsMetaData : normalizationMetaData.getLicenseMetaDataMap().values()) {
            if (!name.equalsIgnoreCase(termsMetaData.getSpdxIdentifier())) continue;
            return termsMetaData;
        }
        for (TermsMetaData termsMetaData : normalizationMetaData.getLicenseMetaDataMap().values()) {
            if (!shortName.equalsIgnoreCase(termsMetaData.getShortName())) continue;
            return termsMetaData;
        }
        if (name.equals("OFL")) {
            return this.findMyShortNameSPDXorOtherId("OFL-?");
        }
        if (name.equals("LGPLv2")) {
            return this.findMyShortNameSPDXorOtherId("LGPL-2.0");
        }
        if (name.equals("GPL+")) {
            return this.findMyShortNameSPDXorOtherId("GPL-?+");
        }
        if (name.equals("GPLv2")) {
            return this.findMyShortNameSPDXorOtherId("GPL-2.0");
        }
        if (name.equals("GPLv2 with exception")) {
            return this.findMyShortNameSPDXorOtherId("GPL-2.0-exceptions");
        }
        if (name.equals("GPLv2+ with exception")) {
            return this.findMyShortNameSPDXorOtherId("GPL-2.0+-exceptions");
        }
        if (name.equals("GPLv2 with exceptions")) {
            return this.findMyShortNameSPDXorOtherId("GPL-2.0-exceptions");
        }
        if (name.equals("GPLv2+ with exceptions")) {
            return this.findMyShortNameSPDXorOtherId("GPL-2.0+-exceptions");
        }
        if (name.equals("LGPLv2+ with exceptions")) {
            return this.findMyShortNameSPDXorOtherId("LGPL-2.0+-exceptions");
        }
        if (name.equals("LGPLv2.1+ with exceptions")) {
            return this.findMyShortNameSPDXorOtherId("LGPL-2.1+-exceptions");
        }
        if (name.equals("GPLv3 with exception")) {
            return this.findMyShortNameSPDXorOtherId("GPL-3.0-exceptions");
        }
        if (name.equals("GPLv3+ with exception")) {
            return this.findMyShortNameSPDXorOtherId("GPL-3.0+-exceptions");
        }
        if (name.equals("GPLv3 with exceptions")) {
            return this.findMyShortNameSPDXorOtherId("GPL-3.0-exceptions");
        }
        if (name.equals("GPLv3+ with exceptions")) {
            return this.findMyShortNameSPDXorOtherId("GPL-3.0+-exceptions");
        }
        if (name.equals("LGPLv3+ with exceptions")) {
            return this.findMyShortNameSPDXorOtherId("LGPL-3.0+-exceptions");
        }
        if (name.equals("BSD")) {
            return this.findMyShortNameSPDXorOtherId("BSD-?");
        }
        if (name.equals("BSD with advertising")) {
            return this.findMyShortNameSPDXorOtherId("BSD-?");
        }
        if (name.equals("Lucida")) {
            return this.findMyShortNameSPDXorOtherId("Lucida Legal Notice");
        }
        if (name.equals("JasPer")) {
            return this.findMyShortNameSPDXorOtherId("JasPer-?");
        }
        if (name.equals("OpenLDAP")) {
            return this.findMyShortNameSPDXorOtherId("OLDAP-?");
        }
        if (name.equals("Boost")) {
            return this.findMyShortNameSPDXorOtherId("BSL-1.0");
        }
        if (name.equals("UCD")) {
            return this.findMyShortNameSPDXorOtherId("UCD-TOU");
        }
        if (!name.contains("-?") && (resolveUnspecific = this.findMyShortNameSPDXorOtherId(shortName + "-?")) != null) {
            return resolveUnspecific;
        }
        return null;
    }

    public void isValid(String licenseExpression, Artifact artifact) {
        if (org.apache.commons.lang3.StringUtils.countMatches((CharSequence)licenseExpression, (CharSequence)"(") != org.apache.commons.lang3.StringUtils.countMatches((CharSequence)licenseExpression, (CharSequence)")")) {
            LOG.error("Odd number of brackets found in {}", (Object)artifact.getId());
        }
        if (licenseExpression.matches(".*\\(\\).*")) {
            LOG.warn("Empty brackets found in {}", (Object)artifact.getId());
        }
    }
}

