/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.File;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.FileLocation;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.IsoTimestamp;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.Task;
import com.metaeffekt.artifact.analysis.flow.grpc.worker.TimeUnit;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.bouncycastle.util.encoders.Base64;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskUtils {
    private static final Logger log = LoggerFactory.getLogger(TaskUtils.class);

    public static String toJsonString(Message message) throws InvalidProtocolBufferException {
        return JsonFormat.printer().print((MessageOrBuilder)message);
    }

    public static IsoTimestamp createIsoTimestamp() {
        IsoTimestamp.Builder iso8601 = IsoTimestamp.newBuilder().setIso8601(DateTime.now().toDateTimeISO().toString()).setPrecision(TimeUnit.MILLIS);
        return iso8601.build();
    }

    public static Task parseTask(File waitingTaskFile) {
        try {
            Task.Builder builder = Task.newBuilder();
            String jsonString = FileUtils.readFileToString((File)waitingTaskFile, (String)"UTF-8");
            JsonFormat.parser().ignoringUnknownFields().merge(jsonString, (Message.Builder)builder);
            return builder.build();
        }
        catch (Exception e) {
            log.warn("Cannot parse task file [{}].", (Object)waitingTaskFile.getAbsolutePath());
            return null;
        }
    }

    public static void toJsonFile(File file, Task task) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)TaskUtils.toJsonString((Message)task), (String)"UTF-8");
    }

    public static com.metaeffekt.artifact.analysis.flow.grpc.worker.File createFile(File baseDir, File file) throws IOException {
        File.Builder builder = com.metaeffekt.artifact.analysis.flow.grpc.worker.File.newBuilder();
        builder.setLocation(TaskUtils.createFileLocation(baseDir, file));
        builder.setBased64Content(TaskUtils.toBase64EncodedString(file));
        return builder.build();
    }

    public static com.metaeffekt.artifact.analysis.flow.grpc.worker.File createTargetFile(String targetBaseDir, String targetRelativePath, File localFile) throws IOException {
        File.Builder builder = com.metaeffekt.artifact.analysis.flow.grpc.worker.File.newBuilder();
        builder.setLocation(TaskUtils.createFileLocation(targetBaseDir, targetRelativePath));
        builder.setBased64Content(TaskUtils.toBase64EncodedString(localFile));
        return builder.build();
    }

    public static FileLocation createFileLocation(File baseDir, File file) {
        String baseDirPath = baseDir.getAbsolutePath();
        String relativePath = FileUtils.asRelativePath((File)baseDir, (File)file);
        return TaskUtils.createFileLocation(baseDirPath, relativePath);
    }

    public static FileLocation createFileLocation(String baseDirPath, String relativePath) {
        return FileLocation.newBuilder().setBaseDir(baseDirPath).setRelativePath(relativePath).build();
    }

    public static String toBase64EncodedString(File inputFile) throws IOException {
        return Base64.toBase64String((byte[])FileUtils.readFileToByteArray((File)inputFile));
    }
}

