/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.workbench;

import com.metaeffekt.artifact.analysis.flow.DocumentFlow;
import com.metaeffekt.artifact.analysis.flow.DocumentFlowParam;
import com.metaeffekt.artifact.analysis.flow.ObserveFolderFlow;
import com.metaeffekt.artifact.analysis.flow.ObserveFolderFlowParam;
import com.metaeffekt.artifact.analysis.flow.ObservePortfolioFlow;
import com.metaeffekt.artifact.analysis.flow.ObservePortfolioFlowParam;
import com.metaeffekt.artifact.analysis.flow.ResolverFlowParam;
import com.metaeffekt.artifact.analysis.flow.ScanConsumer;
import com.metaeffekt.artifact.analysis.flow.ScanFlowParam;
import com.metaeffekt.artifact.analysis.model.DefaultPropertyProvider;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.artifact.analysis.workbench.WorkbenchTaskQueue;
import com.metaeffekt.artifact.analysis.workbench.WorkbenchUtils;
import com.metaeffekt.artifact.analysis.workbench.executors.OverallReportTaskExecutor;
import com.metaeffekt.artifact.analysis.workbench.executors.PrepareTransferTaskExecutor;
import com.metaeffekt.artifact.analysis.workbench.executors.ReportTaskExecutor;
import com.metaeffekt.artifact.analysis.workbench.executors.ResolveTaskExecutor;
import com.metaeffekt.artifact.analysis.workbench.executors.ScanTaskExecutor;
import com.metaeffekt.artifact.analysis.workbench.grpc.WorkerClient;
import com.metaeffekt.artifact.analysis.workbench.grpc.WorkerServer;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.resource.InventoryDirResource;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchExecution {
    private static final Logger LOG = LoggerFactory.getLogger(WorkbenchExecution.class);
    private final File workbenchBaseDir;
    private final File workbenchControlPropertiesFile;
    private final NormalizationMetaData normalizationMetaData;
    private final LicenseTextProvider licenseTextProvider;
    private final WorkbenchTaskQueue workbenchTaskQueue;
    private File referenceInventoryDir;
    private String referenceInventoryIncludes = "inventory/*.xls*";

    public WorkbenchExecution(NormalizationMetaData normalizationMetaData, LicenseTextProvider licenseTextProvider, File workbenchBaseDir, File workbenchControlPropertiesFile) {
        InventoryUtils.initialize((NormalizationMetaData)normalizationMetaData);
        WorkbenchUtils.initialize((NormalizationMetaData)normalizationMetaData);
        this.normalizationMetaData = normalizationMetaData;
        this.licenseTextProvider = licenseTextProvider;
        this.workbenchBaseDir = workbenchBaseDir;
        this.workbenchControlPropertiesFile = workbenchControlPropertiesFile;
        this.workbenchTaskQueue = new WorkbenchTaskQueue(new File(workbenchBaseDir, "tasks"));
    }

    public void configureReferenceInventory(File referenceInventoryDir, String referenceInventoryIncludes) {
        this.referenceInventoryDir = referenceInventoryDir;
        this.referenceInventoryIncludes = referenceInventoryIncludes;
    }

    public void executeWorkbench() throws Exception {
        File scannerInputDir = new File(this.workbenchBaseDir, "scanner/input");
        File scannerOutputDir = new File(this.workbenchBaseDir, "scanner/output");
        File scannerAnalysisDir = new File(this.workbenchBaseDir, "scanner/analysis");
        File scannerTmpBaseDir = new File(this.workbenchBaseDir, "scanner/analysis/tmp");
        File scannerStatusBaseDir = new File(this.workbenchBaseDir, "scanner/status");
        File documentBaseDir = new File(this.workbenchBaseDir, "documents");
        File portfolioSyncBaseDir = new File(this.workbenchBaseDir, "portfolio");
        DefaultPropertyProvider propertyProvider = this.createPropertyProvider();
        WorkerClient scanWorkerClient = this.initializeScanWorkerClient(propertyProvider);
        WorkerClient controlWorkerClient = this.initializeControlWorkerClient(propertyProvider);
        WorkerServer workerServer = this.initializeWorkerServer(propertyProvider, portfolioSyncBaseDir, this.workbenchTaskQueue);
        ScanFlowParam scanFlowParamTemplate = this.createScanFlowParam(this.normalizationMetaData, this.licenseTextProvider, propertyProvider, scannerAnalysisDir);
        ResolverFlowParam resolverFlowParamTemplate = new ResolverFlowParam();
        resolverFlowParamTemplate.configuredBy((PropertyProvider)propertyProvider);
        InventoryDirResource referenceInventoryResource = InventoryDirResource.attach((File)this.referenceInventoryDir, (String)this.referenceInventoryIncludes);
        this.workbenchTaskQueue.add(new ResolveTaskExecutor(resolverFlowParamTemplate));
        this.workbenchTaskQueue.add(new ScanTaskExecutor(scanFlowParamTemplate));
        this.workbenchTaskQueue.add(new PrepareTransferTaskExecutor(controlWorkerClient));
        this.workbenchTaskQueue.add(new ReportTaskExecutor((InventoryResource)referenceInventoryResource));
        this.workbenchTaskQueue.add(new OverallReportTaskExecutor((InventoryResource)referenceInventoryResource));
        ScanConsumer consumer = new ScanConsumer(scannerAnalysisDir, scannerTmpBaseDir, scannerOutputDir, (InventoryResource)referenceInventoryResource, scanFlowParamTemplate);
        ObserveFolderFlowParam param = this.createObserveFolderParam(scannerInputDir, scannerTmpBaseDir, scannerStatusBaseDir, consumer, (PropertyProvider)propertyProvider);
        FileUtils.forceMkdir((File)param.getObservationDir());
        FileUtils.deleteDirectory((File)param.getTmpBaseDir());
        FileUtils.forceMkdir((File)param.getTmpBaseDir());
        DocumentFlowParam documentFlowParam = this.createDocumentFlowParam((PropertyProvider)propertyProvider, documentBaseDir, scannerOutputDir);
        this.workbenchTaskQueue.startProcessing();
        ExecutorService executor = Executors.newFixedThreadPool(6);
        executor.execute(() -> new ObserveFolderFlow().process(param));
        String portfolioBaseDir = propertyProvider.getProperty("workbench.portfolio.dir");
        if (portfolioBaseDir != null && scanWorkerClient != null) {
            ObservePortfolioFlowParam observePortfolioFlowParam = ObservePortfolioFlowParam.builder().portfolioBaseDir(new File(portfolioBaseDir)).workerClient(scanWorkerClient).workbenchTaskQueue(this.workbenchTaskQueue).build();
            observePortfolioFlowParam.configuredBy((PropertyProvider)propertyProvider);
            executor.execute(() -> new ObservePortfolioFlow().loop(observePortfolioFlowParam));
        }
        if (workerServer != null) {
            executor.execute(workerServer::startBlocking);
        }
        executor.execute(() -> {
            while (true) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    new DocumentFlow().process(documentFlowParam);
                    continue;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        });
        while (!executor.isTerminated()) {
            Thread.sleep(2000L);
        }
    }

    private WorkerClient initializeScanWorkerClient(DefaultPropertyProvider propertyProvider) {
        String workerHost = propertyProvider.getProperty("worker.scanner.host");
        String workerPort = propertyProvider.getProperty("worker.scanner.port");
        return this.initializeWorkerClient(workerHost, workerPort);
    }

    private WorkerClient initializeControlWorkerClient(DefaultPropertyProvider propertyProvider) {
        String workerHost = propertyProvider.getProperty("worker.controller.host");
        String workerPort = propertyProvider.getProperty("worker.controller.port");
        return this.initializeWorkerClient(workerHost, workerPort);
    }

    private WorkerClient initializeWorkerClient(String scanWorkerHost, String scanWorkerPort) {
        WorkerClient scanWorkerClient = null;
        if (scanWorkerHost != null && scanWorkerPort != null) {
            scanWorkerClient = new WorkerClient();
            scanWorkerClient.initialize(scanWorkerHost, scanWorkerPort);
        }
        return scanWorkerClient;
    }

    private WorkerServer initializeWorkerServer(DefaultPropertyProvider propertyProvider, File portfolioSyncBaseDir, WorkbenchTaskQueue taskQueue) {
        String workerPort = propertyProvider.getProperty("worker.server.port");
        WorkerServer workerServer = null;
        if (workerPort != null) {
            workerServer = new WorkerServer();
            workerServer.initialize(Integer.parseInt(workerPort), portfolioSyncBaseDir, this.workbenchTaskQueue);
        }
        return workerServer;
    }

    private ObserveFolderFlowParam createObserveFolderParam(File scannerInputDir, File scannerTmpBaseDir, File scannerStatusDir, Consumer<File> consumer, PropertyProvider propertyProvider) {
        ObserveFolderFlowParam param = new ObserveFolderFlowParam(scannerInputDir, scannerStatusDir, scannerTmpBaseDir, consumer);
        param.configuredBy(propertyProvider);
        return param;
    }

    private ScanFlowParam createScanFlowParam(NormalizationMetaData normalizationMetaData, LicenseTextProvider licenseTextProvider, DefaultPropertyProvider propertyProvider, File scannerAnalysisDir) {
        ScanFlowParam scanFlowParamTemplate = (ScanFlowParam)ScanFlowParam.build().using(normalizationMetaData).using(licenseTextProvider).using(scannerAnalysisDir).configuredBy((PropertyProvider)propertyProvider);
        return scanFlowParamTemplate;
    }

    private DefaultPropertyProvider createPropertyProvider() {
        DefaultPropertyProvider propertyProvider = new DefaultPropertyProvider();
        Properties properties = PropertyUtils.loadProperties((File)this.workbenchControlPropertiesFile);
        propertyProvider.putAll((Map)properties);
        return propertyProvider;
    }

    public DocumentFlowParam createDocumentFlowParam(PropertyProvider propertyProvider, File documentBaseDir, File scannerOutputDir) {
        String sourceInventoryPattern = "license-scanner-inventory-*.xls*";
        File documentOutputDir = new File(documentBaseDir, "output");
        File documentTempBaseDir = new File(documentBaseDir, "tmp");
        File documentControlFile = new File(documentBaseDir, "document-control.xlsx");
        DocumentFlowParam documentFlowParam = new DocumentFlowParam().withDocumentControl(documentControlFile).useScannerOutputDir(scannerOutputDir).useScannerInventoryOutputPattern("license-scanner-inventory-*.xls*").useTempBaseDir(documentTempBaseDir).publishResultsTo(documentOutputDir).using(this.normalizationMetaData).using(this.licenseTextProvider).withReferenceInventory(this.referenceInventoryDir, this.referenceInventoryIncludes);
        documentFlowParam.configuredBy(propertyProvider);
        return documentFlowParam;
    }
}

